#include<stdio.h>
#include<stdlib.h>
#include<string.h>

typedef struct{
	char nome[50];
	int n;
}element;
typedef struct{
	char nome[50];
	int ord;
}pranzo;
typedef struct tree_element{
	element value;
	struct tree_element *left,*right;
}nodo;
typedef nodo* tree;
typedef enum{FALSE,TRUE}boolean;

boolean empty(tree t){
	if(t==NULL)
		return TRUE;
	else
		return FALSE;
}
tree emptyTree(){
	return NULL;
}
element root(tree t){
	return t->value;
}
tree cons(element el,tree l,tree r){
	tree t=emptyTree();
	t=(tree)malloc(sizeof(nodo));
	t->value=el;
	t->left=l;
	t->right=r;
	return t;
}
tree insord(element el,tree t){
	if(empty(t))
		return cons(el,NULL,NULL);
	else{
		if(strcmp(el.nome,(root(t)).nome)<=0)
			t->left=insord(el,t->left);
		else
			t->right=insord(el,t->right);
		return t;
	}
}
tree funzioneA(FILE *f,tree t){
	element el;
	while(fread(&el,sizeof(element),1,f)>0)
		t=insord(el,t);
	return t;
}
void funzioneB(tree t){
	if(!empty(t)){
		funzioneB(t->left);
		printf("%s %d\n",(root(t)).nome,(root(t)).n);
		funzioneB(t->right);
	}
}
int member(char nome[],tree t){
	if(empty(t))
		return 0;
	else{
		if(strcmp(nome,(root(t)).nome)==0)
			return (root(t)).n;
		else{
			if(strcmp(nome,(root(t)).nome)<0)
				return member(nome,t->left);
			else
				return member(nome,t->right);
			}
		}
}

void funzioneC(FILE *f,FILE *g,tree t){
	pranzo p;
	while(fscanf(f,"%s %d",p.nome,&p.ord)!=EOF){
		if(member(p.nome,t)>=p.ord)
			fprintf(g,"%s\n",p.nome);
	}
}

main(){
	FILE *f,*g,*h;
	tree t=emptyTree();

	f=fopen("alimenti.bin","rb");
	if(f==NULL){
		printf("Errore apertura primo file");
		exit(-1);
	}
	t=funzioneA(f,t);
	fclose(f);
	funzioneB(t);
	g=fopen("pranzo.txt","rt");
	if(g==NULL){
		printf("Errore apertura secondo file");
		exit(-1);
	}
	h=fopen("output.txt","wt");
	if(h==NULL){
		printf("Errore apertura terzo file");
		exit(-1);
	}
	funzioneC(g,h,t);
	fclose(g);
	fclose(h);
}