#include "liste.h"

/*FUNZIONI PRIMITIVE DEL TIPO DI DATO ASTRATTO LISTA SEMPLICE*/

element head(list l){	/*funzione che emette il valore del campo del primo elemento della lista l*/
	if (empty(l))
		abort();
	else
		return l->value;
}


list tail(list l){	/*fornisce il puntatore all'elemento successivo a quello che il puntatore l punta*/
	if (empty(l))
		abort();
	else
		return l->next;
}


list emptyList(){	/*funzione che fornisce una lista vuota*/
	return NULL;
}


boolean empty(list l){	/*test che stabilisce la lista passata come parametro è vuota o meno*/
	if (l == NULL)
		return true;
	else
		return false;
}

list cons(element n, list l){
	list aux = NULL;

	aux = (list)malloc(sizeof(listNode));
	aux->value = n;
	aux->next = l;
	return aux;
}

list insord(element el, list l) {
	if (l == NULL)
		return cons(el, l);
	else if (isLess(el, head(l)))
		return cons(el, l);
	else {
		l->next = insord(el, l->next);
		return l;
	}
}

list append(list l1, list l2) {
	if (empty(l1)) {
		return l2;
	}
	else {
		return cons(head(l1), append(tail(l1), l2));
	}
}

list merge(list l1, list l2) {
	if (!empty(l1) && !empty(l2))
	{
		if (isLess(head(l1), head(l2)))
			return cons(head(l1), merge(tail(l1), l2));
		else
			return cons(head(l2), merge(l1, tail(l2)));
	}

	if (empty(l1) && !empty(l2))
		return cons(head(l2), merge(l1, tail(l2)));
	else if (!empty(l1) && empty(l2))
		return cons(head(l1), merge(tail(l1), l2));
	else
		return emptyList();
}

void showlist(list l) {

	if (l != NULL){
		printElement(l->value);
		showlist(l->next);
	}
	else{
		printf("\n");
	}
}

