/*
 * Decompiled with CFR 0.152.
 */
package aima.basic;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Tokenizer
implements Enumeration {
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    private String str = null;
    private String delim = null;
    private boolean returnTokens = false;
    private int previous = -1;
    private int current = 0;
    private int max = 0;

    public Tokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.delim = string2;
        this.returnTokens = bl;
        this.max = string.length();
    }

    public Tokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public Tokenizer(String string, char c) {
        this(string, String.valueOf(c), false);
    }

    public Tokenizer(String string) {
        this(string, DEFAULT_DELIMITERS, false);
    }

    public boolean hasMoreTokens() {
        return this.current < this.max ? true : this.current == this.max && (this.max == 0 || this.returnTokens && this.delim.indexOf(this.str.charAt(this.previous)) >= 0);
    }

    public String nextToken() throws NoSuchElementException {
        if (this.current == this.max && (this.max == 0 || this.returnTokens && this.delim.indexOf(this.str.charAt(this.previous)) >= 0)) {
            ++this.current;
            return new String();
        }
        if (this.current >= this.max) {
            throw new NoSuchElementException();
        }
        int n = this.current;
        String string = null;
        if (this.delim.indexOf(this.str.charAt(n)) >= 0) {
            if (this.previous == -1 || this.returnTokens && this.previous != this.current && this.delim.indexOf(this.str.charAt(this.previous)) >= 0) {
                string = new String();
            } else if (this.returnTokens) {
                string = this.str.substring(n, ++this.current);
            }
            if (!this.returnTokens) {
                ++this.current;
            }
        }
        this.previous = n;
        n = this.current;
        if (string == null) {
            while (this.current < this.max && this.delim.indexOf(this.str.charAt(this.current)) < 0) {
                ++this.current;
            }
        }
        return string == null ? this.str.substring(n, this.current) : string;
    }

    public String nextToken(String string) throws NoSuchElementException {
        this.delim = string;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n = this.current;
        int n2 = 0;
        for (int i = n; i < this.max; ++i) {
            if (this.delim.indexOf(this.str.charAt(i)) >= 0) {
                ++n2;
            }
            ++n;
        }
        return n2 + (this.returnTokens ? n2 : 0) + 1;
    }

    public void reset() {
        this.previous = -1;
        this.current = 0;
    }

    public static String[] tokenize(String string, String string2, boolean bl) {
        Tokenizer tokenizer = new Tokenizer(string, string2, bl);
        String[] stringArray = new String[tokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = tokenizer.nextToken();
        }
        return stringArray;
    }
}

