/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.games.AlphaBeta;
import aima.games.GameState;
import aima.util.Util;
import java.util.ArrayList;

public abstract class Game {
    protected GameState initialState = new GameState();
    protected GameState presentState = new GameState();
    protected int level;

    public int getLevel(GameState gameState) {
        return (Integer)gameState.get("level");
    }

    public ArrayList getMoves(GameState gameState) {
        return (ArrayList)gameState.get("moves");
    }

    public String getPlayerToMove(GameState gameState) {
        return (String)gameState.get("player");
    }

    public int getUtility(GameState gameState) {
        return (Integer)gameState.get("utility");
    }

    public GameState getState() {
        return this.presentState;
    }

    protected abstract int computeUtility(GameState var1);

    protected abstract boolean terminalTest(GameState var1);

    public int maxValue(GameState gameState) {
        int n = Integer.MIN_VALUE;
        if (this.terminalTest(gameState)) {
            return this.computeUtility(gameState);
        }
        ArrayList arrayList = this.getSuccessorStates(gameState);
        for (int i = 0; i < arrayList.size(); ++i) {
            GameState gameState2 = (GameState)arrayList.get(i);
            int n2 = this.minValue(gameState2);
            if (n2 <= n) continue;
            n = n2;
            gameState.put("next", gameState2);
        }
        return n;
    }

    public int minValue(GameState gameState) {
        int n = Integer.MAX_VALUE;
        if (this.terminalTest(gameState)) {
            return this.computeUtility(gameState);
        }
        ArrayList arrayList = this.getSuccessorStates(gameState);
        for (int i = 0; i < arrayList.size(); ++i) {
            GameState gameState2 = (GameState)arrayList.get(i);
            int n2 = this.maxValue(gameState2);
            if (n2 >= n) continue;
            n = n2;
            gameState.put("next", gameState2);
        }
        return n;
    }

    protected int maxValue(GameState gameState, AlphaBeta alphaBeta) {
        int n = Integer.MIN_VALUE;
        if (this.terminalTest(gameState)) {
            return this.computeUtility(gameState);
        }
        ArrayList arrayList = this.getSuccessorStates(gameState);
        for (int i = 0; i < arrayList.size(); ++i) {
            GameState gameState2 = (GameState)arrayList.get(i);
            int n2 = this.minValue(gameState2, alphaBeta.copy());
            if (n2 > n) {
                n = n2;
                gameState.put("next", gameState2);
            }
            if (n >= alphaBeta.beta()) {
                return n;
            }
            alphaBeta.setAlpha(Util.max(alphaBeta.alpha(), n));
        }
        return n;
    }

    public int minValue(GameState gameState, AlphaBeta alphaBeta) {
        int n = Integer.MAX_VALUE;
        if (this.terminalTest(gameState)) {
            return this.computeUtility(gameState);
        }
        ArrayList arrayList = this.getSuccessorStates(gameState);
        for (int i = 0; i < arrayList.size(); ++i) {
            GameState gameState2 = (GameState)arrayList.get(i);
            int n2 = this.maxValue(gameState2, alphaBeta.copy());
            if (n2 < n) {
                n = n2;
                gameState.put("next", gameState2);
            }
            if (n <= alphaBeta.alpha()) {
                return n;
            }
            alphaBeta.setBeta(Util.min(alphaBeta.beta(), n));
        }
        return n;
    }

    public void makeMiniMaxMove() {
        this.getMiniMaxValue(this.presentState);
        GameState gameState = (GameState)this.presentState.get("next");
        if (gameState == null) {
            throw new RuntimeException("Mini Max Move failed");
        }
        this.makeMove(this.presentState, gameState.get("moveMade"));
    }

    public void makeAlphaBetaMove() {
        this.getAlphaBetaValue(this.presentState);
        GameState gameState = (GameState)this.presentState.get("next");
        if (gameState == null) {
            throw new RuntimeException("Alpha Beta Move failed");
        }
        this.makeMove(this.presentState, gameState.get("moveMade"));
    }

    public abstract ArrayList getSuccessorStates(GameState var1);

    public abstract GameState makeMove(GameState var1, Object var2);

    public boolean hasEnded() {
        return this.terminalTest(this.getState());
    }

    public abstract int getMiniMaxValue(GameState var1);

    public abstract int getAlphaBetaValue(GameState var1);
}

