/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.basic.XYLocation;
import aima.games.AlphaBeta;
import aima.games.Game;
import aima.games.GameState;
import aima.games.TicTacToeBoard;
import java.util.ArrayList;

public class TicTacToe
extends Game {
    public TicTacToe() {
        ArrayList<XYLocation> arrayList = new ArrayList<XYLocation>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                XYLocation xYLocation = new XYLocation(i, j);
                arrayList.add(xYLocation);
            }
        }
        this.initialState.put("moves", arrayList);
        this.initialState.put("player", "X");
        this.initialState.put("utility", new Integer(0));
        this.initialState.put("board", new TicTacToeBoard());
        this.initialState.put("level", new Integer(0));
        this.presentState = this.initialState;
    }

    public TicTacToeBoard getBoard(GameState gameState) {
        return (TicTacToeBoard)gameState.get("board");
    }

    @Override
    public ArrayList getSuccessorStates(GameState gameState) {
        GameState gameState2 = this.presentState;
        ArrayList<GameState> arrayList = new ArrayList<GameState>();
        int n = this.getLevel(gameState);
        for (int i = 0; i < this.getMoves(gameState).size(); ++i) {
            XYLocation xYLocation = (XYLocation)this.getMoves(gameState).get(i);
            GameState gameState3 = this.makeMove(gameState, xYLocation);
            gameState3.put("moveMade", xYLocation);
            gameState3.put("level", new Integer(n + 1));
            arrayList.add(gameState3);
        }
        this.presentState = gameState2;
        return arrayList;
    }

    @Override
    public GameState makeMove(GameState gameState, Object object) {
        XYLocation xYLocation = (XYLocation)object;
        return this.makeMove(gameState, xYLocation.getXCoOrdinate(), xYLocation.getYCoOrdinate());
    }

    public GameState makeMove(GameState gameState, int n, int n2) {
        GameState gameState2 = this.getMove(gameState, n, n2);
        if (gameState2 != null) {
            this.presentState = gameState2;
        }
        return this.presentState;
    }

    public GameState makeMove(int n, int n2) {
        GameState gameState = this.presentState;
        GameState gameState2 = this.getMove(gameState, n, n2);
        if (gameState2 != null) {
            this.presentState = gameState2;
        }
        return this.presentState;
    }

    public GameState getMove(GameState gameState, int n, int n2) {
        GameState gameState2 = null;
        XYLocation xYLocation = new XYLocation(n, n2);
        ArrayList arrayList = this.getMoves(gameState);
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        if (arrayList.contains(xYLocation)) {
            int n3 = arrayList2.indexOf(xYLocation);
            arrayList2.remove(n3);
            gameState2 = new GameState();
            gameState2.put("moves", arrayList2);
            TicTacToeBoard ticTacToeBoard = this.getBoard(gameState).cloneBoard();
            if (this.getPlayerToMove(gameState) == "X") {
                ticTacToeBoard.markX(n, n2);
                gameState2.put("player", "O");
            } else {
                ticTacToeBoard.markO(n, n2);
                gameState2.put("player", "X");
            }
            gameState2.put("board", ticTacToeBoard);
            gameState2.put("utility", new Integer(this.computeUtility(ticTacToeBoard, this.getPlayerToMove(this.getState()))));
            gameState2.put("level", new Integer(this.getLevel(gameState) + 1));
        }
        return gameState2;
    }

    @Override
    public int computeUtility(GameState gameState) {
        int n = this.computeUtility((TicTacToeBoard)gameState.get("board"), this.getPlayerToMove(gameState));
        return n;
    }

    private int computeUtility(TicTacToeBoard ticTacToeBoard, String string) {
        int n = 0;
        if (ticTacToeBoard.lineThroughBoard()) {
            n = string.equals("X") ? -1 : 1;
        }
        return n;
    }

    @Override
    public boolean terminalTest(GameState gameState) {
        TicTacToeBoard ticTacToeBoard = (TicTacToeBoard)gameState.get("board");
        boolean bl = ticTacToeBoard.lineThroughBoard();
        boolean bl2 = ticTacToeBoard.getNumberOfMarkedPositions() == 9;
        return bl || bl2;
    }

    public void printPossibleMoves() {
        System.out.println("Possible moves");
        ArrayList arrayList = this.getMoves(this.presentState);
        for (int i = 0; i < arrayList.size(); ++i) {
            XYLocation xYLocation = (XYLocation)arrayList.get(i);
            GameState gameState = this.getMove(this.presentState, xYLocation.getXCoOrdinate(), xYLocation.getYCoOrdinate());
            TicTacToeBoard ticTacToeBoard = (TicTacToeBoard)gameState.get("board");
            System.out.println("utility = " + this.computeUtility(gameState));
            System.out.println("");
        }
    }

    @Override
    public int getMiniMaxValue(GameState gameState) {
        if (this.getPlayerToMove(gameState).equalsIgnoreCase("X")) {
            return this.maxValue(gameState);
        }
        return this.minValue(gameState);
    }

    @Override
    public int getAlphaBetaValue(GameState gameState) {
        if (this.getPlayerToMove(gameState).equalsIgnoreCase("X")) {
            AlphaBeta alphaBeta = new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE);
            int n = this.maxValue(gameState, alphaBeta);
            return n;
        }
        AlphaBeta alphaBeta = new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE);
        return this.minValue(gameState, alphaBeta);
    }
}

