/*
 * Decompiled with CFR 0.152.
 */
package aima.games;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class TicTacToeBoard {
    private static final String O = "O";
    private static final String X = "X";
    String[] topRow = new String[]{" ", " ", " "};
    String[] midRow = new String[]{" ", " ", " "};
    String[] bottomRow = new String[]{" ", " ", " "};

    private String[] whichRow(int n) {
        String[] stringArray = null;
        if (n == 0) {
            stringArray = this.topRow;
        } else if (n == 1) {
            stringArray = this.midRow;
        } else if (n == 2) {
            stringArray = this.bottomRow;
        }
        return stringArray;
    }

    public boolean isEmpty(int n, int n2) {
        String[] stringArray = this.whichRow(n);
        return stringArray[n2] == " ";
    }

    public void markX(int n, int n2) {
        this.mark(n, n2, X);
    }

    public void markO(int n, int n2) {
        this.mark(n, n2, O);
    }

    public void mark(int n, int n2, String string) {
        String[] stringArray = null;
        stringArray = this.whichRow(n);
        stringArray[n2] = string;
    }

    public boolean isAnyRowComplete() {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            String[] stringArray = this.whichRow(i);
            if (stringArray[0] == " " || stringArray[0] != stringArray[1] || stringArray[1] != stringArray[2]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isAnyColumnComplete() {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            if (this.topRow[i] == " " || this.topRow[i] != this.midRow[i] || this.midRow[i] != this.bottomRow[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isAnyDiagonalComplete() {
        boolean bl = false;
        if (this.topRow[0] != " " && this.topRow[0] == this.midRow[1] && this.midRow[1] == this.bottomRow[2]) {
            bl = true;
        } else if (this.topRow[2] != " " && this.topRow[2] == this.midRow[1] && this.midRow[1] == this.bottomRow[0]) {
            bl = true;
        }
        return bl;
    }

    public boolean lineThroughBoard() {
        return this.isAnyRowComplete() || this.isAnyColumnComplete() || this.isAnyDiagonalComplete();
    }

    public String getValue(int n, int n2) {
        String[] stringArray = this.whichRow(n);
        return stringArray[n2];
    }

    private void setValue(int n, int n2, String string) {
        String[] stringArray = this.whichRow(n);
        stringArray[n2] = string;
    }

    public void print() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String string = this.getValue(i, j);
                String string2 = string == " " ? "-" : string;
                System.out.print(string2 + " ");
            }
            System.out.println();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String string = this.getValue(i, j);
                String string2 = string == " " ? "-" : string;
                stringBuffer.append(string2 + " ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public TicTacToeBoard cloneBoard() {
        return (TicTacToeBoard)this.clone();
    }

    public Object clone() {
        TicTacToeBoard ticTacToeBoard = new TicTacToeBoard();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String string = this.getValue(i, j);
                ticTacToeBoard.setValue(i, j, string);
            }
        }
        return ticTacToeBoard;
    }

    public int getNumberOfMarkedPositions() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.isEmpty(i, j)) continue;
                ++n;
            }
        }
        return n;
    }

    public List getUnMarkedPositions() {
        ArrayList<XYLocation> arrayList = new ArrayList<XYLocation>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.isEmpty(i, j)) continue;
                arrayList.add(new XYLocation(i, j));
            }
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        TicTacToeBoard ticTacToeBoard = (TicTacToeBoard)object;
        boolean bl2 = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (ticTacToeBoard.getValue(i, j) == this.getValue(i, j)) continue;
                bl = false;
                bl2 = true;
                break;
            }
            if (!bl2) break;
        }
        return bl;
    }

    public boolean isMarked(String string, int n, int n2) {
        return this.getValue(n, n2).equals(string);
    }
}

