/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.basic.Agent;
import aima.gui.applications.search.map.MapAgentFrame;
import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.search.framework.Search;
import aima.search.framework.SearchFactory;
import aima.search.map.AdaptableHeuristicFunction;
import aima.search.map.Scenario;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMapAgentController
extends AgentAppController {
    protected Scenario scenario;
    protected List<String> destinations;
    protected Search search;
    protected AdaptableHeuristicFunction heuristic;

    @Override
    public void clearAgent() {
        ((MapAgentModel)this.model).clearTourHistory();
        this.frame.modelChanged();
    }

    @Override
    public void prepareAgent() {
        AgentAppFrame.SelectionState selectionState = this.frame.getSelection();
        this.selectScenarioAndDest(selectionState.getValue(MapAgentFrame.SCENARIO_SEL), selectionState.getValue(MapAgentFrame.DESTINATION_SEL));
        this.prepareModel();
        this.search = SearchFactory.getInstance().createSearch(selectionState.getValue(MapAgentFrame.SEARCH_SEL), selectionState.getValue(MapAgentFrame.SEARCH_MODE_SEL));
        this.heuristic = this.createHeuristic(selectionState.getValue(MapAgentFrame.HEURISTIC_SEL));
        this.scenario.getEnv().registerView(this.model);
    }

    @Override
    public void runAgent() {
        this.startAgent();
        ArrayList arrayList = this.scenario.getEnv().getAgents();
        if (arrayList.size() == 1) {
            Agent agent = (Agent)arrayList.get(0);
            String string = (String)agent.getAttribute("status");
            Double d = (Double)agent.getAttribute("travelDistance");
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append("Agent status: " + string);
            } else {
                stringBuffer.append("Task completed");
            }
            if (d != null) {
                DecimalFormat decimalFormat = new DecimalFormat("#0.0");
                stringBuffer.append("; travel distance: " + decimalFormat.format(d));
            }
            stringBuffer.append(".");
            this.frame.setStatus(stringBuffer.toString());
        }
    }

    protected abstract void selectScenarioAndDest(int var1, int var2);

    protected abstract void prepareModel();

    protected abstract AdaptableHeuristicFunction createHeuristic(int var1);

    protected abstract void startAgent();
}

