/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentView;
import aima.search.framework.SearchFactory;
import aima.search.map.Map;
import aima.search.map.Point2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class MapAgentFrame
extends AgentAppFrame {
    public static String SCENARIO_SEL = "ScenarioSelection";
    public static String DESTINATION_SEL = "DestinationSelection";
    public static String AGENT_SEL = "AgentSelection";
    public static String SEARCH_SEL = "SearchSelection";
    public static String SEARCH_MODE_SEL = "SearchModeSelection";
    public static String HEURISTIC_SEL = "HeuristicSelection";

    public MapAgentFrame() {
        this.setSelectors(new String[]{SCENARIO_SEL, DESTINATION_SEL, AGENT_SEL, SEARCH_SEL, SEARCH_MODE_SEL, HEURISTIC_SEL}, new String[]{"Select Scenario", "Select Destinations", "Select Agent", "Select Search Strategy", "Select Search Mode", "Select Heuristic"});
        this.setSelectorItems(SEARCH_SEL, SearchFactory.getInstance().getSearchStrategyNames(), 5);
        this.setSelectorItems(SEARCH_MODE_SEL, SearchFactory.getInstance().getSearchModeNames(), 0);
        this.setAgentView(new MapAgentView());
        this.setSplitPaneResizeWeight(0.75);
        this.setUpdateDelay(500);
        this.setSize(1000, 700);
    }

    private static class Roadblock {
        Point2D pos1;
        Point2D pos2;
        boolean inEnvMap;
        boolean inAgentMap;

        private Roadblock(Point2D point2D, Point2D point2D2, boolean bl, boolean bl2) {
            this.pos1 = point2D;
            this.pos2 = point2D2;
            this.inEnvMap = bl;
            this.inAgentMap = bl2;
        }
    }

    class MapAgentView
    extends AgentView {
        MapAgentView() {
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            MapAgentModel mapAgentModel = (MapAgentModel)this.model;
            if (mapAgentModel != null && !mapAgentModel.isEmpty()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                this.adjustTransformation();
                this.paintMap(graphics2D);
                this.paintTour(graphics2D);
                for (String string : mapAgentModel.getLocations()) {
                    this.paintLoc(graphics2D, string);
                }
            }
        }

        private void adjustTransformation() {
            MapAgentModel mapAgentModel = (MapAgentModel)this.model;
            List<String> list = mapAgentModel.getLocations();
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (String string : list) {
                Point2D point2D = mapAgentModel.getLocCoords(string);
                if (point2D.getX() < d) {
                    d = point2D.getX();
                }
                if (point2D.getY() < d2) {
                    d2 = point2D.getY();
                }
                if (point2D.getX() > d3) {
                    d3 = point2D.getX();
                }
                if (!(point2D.getY() > d4)) continue;
                d4 = point2D.getY();
            }
            this.setBorder(20, 20, 20, 100);
            this.adjustTransformation(d, d2, d3, d4);
        }

        private void paintMap(Graphics2D graphics2D) {
            MapAgentModel mapAgentModel = (MapAgentModel)this.model;
            Map map = mapAgentModel.getEnvMap();
            Map map2 = mapAgentModel.getAgentMap();
            ArrayList<Roadblock> arrayList = new ArrayList<Roadblock>();
            for (String object : mapAgentModel.getLocations()) {
                Point2D point2D = mapAgentModel.getLocCoords(object);
                List<String> list = map.getLocationsLinkedTo(object);
                for (String string : map2.getLocationsLinkedTo(object)) {
                    if (list.contains(string)) continue;
                    list.add(string);
                }
                for (String string : list) {
                    Point2D point2D2 = mapAgentModel.getLocCoords(string);
                    graphics2D.setColor(Color.lightGray);
                    graphics2D.drawLine(this.x(point2D), this.y(point2D), this.x(point2D2), this.y(point2D2));
                    boolean bl = !map.getLocationsLinkedTo(string).contains(object);
                    boolean bl2 = !map2.getLocationsLinkedTo(string).contains(object);
                    arrayList.add(new Roadblock(point2D, point2D2, bl, bl2));
                    if (!bl || !bl2) continue;
                    boolean bl3 = !map.getLocationsLinkedTo(object).contains(string);
                    boolean bl4 = !map2.getLocationsLinkedTo(object).contains(string);
                    arrayList.add(new Roadblock(point2D2, point2D, bl3, bl4));
                }
            }
            for (Roadblock roadblock : arrayList) {
                this.paintRoadblock(graphics2D, roadblock);
            }
        }

        private void paintTour(Graphics2D graphics2D) {
            MapAgentModel mapAgentModel = (MapAgentModel)this.model;
            Point2D point2D = null;
            graphics2D.setColor(Color.red);
            for (String string : mapAgentModel.getTourHistory()) {
                Point2D point2D2 = mapAgentModel.getLocCoords(string);
                if (point2D2 != null && point2D != null) {
                    graphics2D.drawLine(this.x(point2D2), this.y(point2D2), this.x(point2D), this.y(point2D));
                }
                point2D = point2D2;
            }
        }

        private void paintRoadblock(Graphics2D graphics2D, Roadblock roadblock) {
            if (roadblock.inEnvMap || roadblock.inAgentMap) {
                int n = (int)(0.2 * (double)this.x(roadblock.pos1) + 0.8 * (double)this.x(roadblock.pos2) - 4.0);
                int n2 = (int)(0.2 * (double)this.y(roadblock.pos1) + 0.8 * (double)this.y(roadblock.pos2) - 4.0);
                if (!roadblock.inAgentMap) {
                    graphics2D.setColor(Color.blue);
                } else if (!roadblock.inEnvMap) {
                    graphics2D.setColor(Color.red);
                } else {
                    graphics2D.setColor(Color.lightGray);
                }
                graphics2D.fillRect(n, n2, 9, 9);
            }
        }

        private void paintLoc(Graphics2D graphics2D, String string) {
            MapAgentModel mapAgentModel = (MapAgentModel)this.model;
            Point2D point2D = mapAgentModel.getLocCoords(string);
            if (point2D != null) {
                int n = this.x(point2D);
                int n2 = this.y(point2D);
                String string2 = "";
                List<String> list = mapAgentModel.getTourHistory();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).equals(string)) continue;
                    arrayList.add(i + 1);
                }
                if (!arrayList.isEmpty()) {
                    string2 = arrayList.toString();
                }
                if (mapAgentModel.hasObjects(string)) {
                    graphics2D.setColor(Color.green);
                    graphics2D.fillOval(n - 5, n2 - 5, 10, 10);
                }
                if (mapAgentModel.isStart(string)) {
                    graphics2D.setColor(Color.red);
                    graphics2D.fillOval(n - 7, n2 - 7, 14, 14);
                }
                if (!list.isEmpty() && string.equals(list.get(list.size() - 1))) {
                    graphics2D.setColor(Color.red);
                    graphics2D.fillOval(n - 4, n2 - 4, 8, 8);
                }
                if (mapAgentModel.hasInfos(string)) {
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawString("i", n, n2 + 12);
                }
                if (mapAgentModel.isDestination(string)) {
                    graphics2D.setColor(Color.green);
                } else if (list.contains(string)) {
                    graphics2D.setColor(Color.black);
                } else {
                    graphics2D.setColor(Color.gray);
                }
                graphics2D.drawString(string + string2, n, n2);
            }
        }
    }
}

