/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.Attribute;
import aima.learning.framework.AttributeSpecification;
import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetSpecification;
import aima.learning.framework.Example;
import aima.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class DataSetFactory {
    public DataSet fromFile(String string, DataSetSpecification dataSetSpecification, String string2) throws Exception {
        String string3;
        DataSet dataSet = new DataSet(dataSetSpecification);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("../data/" + string + ".csv")));
        while ((string3 = bufferedReader.readLine()) != null) {
            dataSet.add(DataSetFactory.exampleFromString(string3, dataSetSpecification, string2));
        }
        return dataSet;
    }

    public static Example exampleFromString(String string, DataSetSpecification dataSetSpecification, String string2) {
        Hashtable<String, Attribute> hashtable = new Hashtable<String, Attribute>();
        List<String> list = Arrays.asList(string.split(string2));
        if (dataSetSpecification.isValid(list)) {
            AttributeSpecification attributeSpecification;
            String string3;
            List<String> list2 = dataSetSpecification.getAttributeNames();
            Iterator<String> iterator = list2.iterator();
            Iterator<String> iterator2 = list.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                string3 = iterator.next();
                attributeSpecification = dataSetSpecification.getAttributeSpecFor(string3);
                Attribute attribute = attributeSpecification.createAttribute(iterator2.next());
                hashtable.put(string3, attribute);
            }
            string3 = dataSetSpecification.getTarget();
            attributeSpecification = dataSetSpecification.getAttributeSpecFor(string3);
            return new Example(hashtable, (Attribute)hashtable.get(string3));
        }
        throw new RuntimeException("Unable to construct Example from " + string);
    }

    public static DataSet getRestaurantDataSet() throws Exception {
        DataSetSpecification dataSetSpecification = DataSetFactory.createRestaurantDataSetSpec();
        return new DataSetFactory().fromFile("restaurant", dataSetSpecification, "\\s+");
    }

    public static DataSetSpecification createRestaurantDataSetSpec() {
        DataSetSpecification dataSetSpecification = new DataSetSpecification();
        dataSetSpecification.defineStringAttribute("alternate", Util.yesno());
        dataSetSpecification.defineStringAttribute("bar", Util.yesno());
        dataSetSpecification.defineStringAttribute("fri/sat", Util.yesno());
        dataSetSpecification.defineStringAttribute("hungry", Util.yesno());
        dataSetSpecification.defineStringAttribute("patrons", new String[]{"None", "Some", "Full"});
        dataSetSpecification.defineStringAttribute("price", new String[]{"$", "$$", "$$$"});
        dataSetSpecification.defineStringAttribute("raining", Util.yesno());
        dataSetSpecification.defineStringAttribute("reservation", Util.yesno());
        dataSetSpecification.defineStringAttribute("type", new String[]{"French", "Italian", "Thai", "Burger"});
        dataSetSpecification.defineStringAttribute("wait_estimate", new String[]{"0-10", "10-30", "30-60", ">60"});
        dataSetSpecification.defineStringAttribute("will_wait", Util.yesno());
        return dataSetSpecification;
    }

    public static DataSet getIrisDataSet() throws Exception {
        DataSetSpecification dataSetSpecification = DataSetFactory.createIrisDataSetSpec();
        return new DataSetFactory().fromFile("iris", dataSetSpecification, ",");
    }

    public static DataSetSpecification createIrisDataSetSpec() {
        DataSetSpecification dataSetSpecification = new DataSetSpecification();
        dataSetSpecification.defineNumericAttribute("sepal_length");
        dataSetSpecification.defineNumericAttribute("sepal_width");
        dataSetSpecification.defineNumericAttribute("petal_length");
        dataSetSpecification.defineNumericAttribute("petal_width");
        dataSetSpecification.defineStringAttribute("plant_category", new String[]{"setosa", "versicolor", "virginica"});
        return dataSetSpecification;
    }
}

