/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.AttributeSpecification;
import aima.learning.framework.NumericAttributeSpecification;
import aima.learning.framework.StringAttributeSpecification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataSetSpecification {
    List<AttributeSpecification> attributeSpecifications = new ArrayList<AttributeSpecification>();
    private String targetAttribute;

    public boolean isValid(List<String> list) {
        if (this.attributeSpecifications.size() != list.size()) {
            throw new RuntimeException("size mismatch specsize = " + this.attributeSpecifications.size() + " attrbutes size = " + list.size());
        }
        Iterator<AttributeSpecification> iterator = this.attributeSpecifications.iterator();
        Iterator<String> iterator2 = list.iterator();
        while (iterator2.hasNext() && iterator.hasNext()) {
            if (iterator.next().isValid(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public String getTarget() {
        return this.targetAttribute;
    }

    public List<String> getPossibleAttributeValues(String string) {
        for (AttributeSpecification attributeSpecification : this.attributeSpecifications) {
            if (!attributeSpecification.getAttributeName().equals(string)) continue;
            return ((StringAttributeSpecification)attributeSpecification).possibleAttributeValues();
        }
        throw new RuntimeException("No such attribute" + string);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AttributeSpecification attributeSpecification : this.attributeSpecifications) {
            arrayList.add(attributeSpecification.getAttributeName());
        }
        return arrayList;
    }

    public void defineStringAttribute(String string, String[] stringArray) {
        this.attributeSpecifications.add(new StringAttributeSpecification(string, stringArray));
        this.setTarget(string);
    }

    public void setTarget(String string) {
        this.targetAttribute = string;
    }

    public AttributeSpecification getAttributeSpecFor(String string) {
        for (AttributeSpecification attributeSpecification : this.attributeSpecifications) {
            if (!attributeSpecification.getAttributeName().equals(string)) continue;
            return attributeSpecification;
        }
        throw new RuntimeException("no attribute spec for  " + string);
    }

    public void defineNumericAttribute(String string) {
        this.attributeSpecifications.add(new NumericAttributeSpecification(string));
    }

    public List<String> getNamesOfStringAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AttributeSpecification attributeSpecification : this.attributeSpecifications) {
            if (!(attributeSpecification instanceof StringAttributeSpecification)) continue;
            arrayList.add(attributeSpecification.getAttributeName());
        }
        return arrayList;
    }
}

