/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.Attribute;
import aima.learning.framework.NumericAttribute;
import aima.learning.framework.NumericAttributeSpecification;
import aima.learning.framework.StringAttribute;
import java.util.Hashtable;

public class Example {
    Hashtable<String, Attribute> attributes;
    private Attribute targetAttribute;

    public Example(Hashtable<String, Attribute> hashtable, Attribute attribute) {
        this.attributes = hashtable;
        this.targetAttribute = attribute;
    }

    public String getAttributeValueAsString(String string) {
        return this.attributes.get(string).valueAsString();
    }

    public double getAttributeValueAsDouble(String string) {
        Attribute attribute = this.attributes.get(string);
        if (attribute == null || !(attribute instanceof NumericAttribute)) {
            throw new RuntimeException("cannot return numerical value for non numeric attribute");
        }
        return ((NumericAttribute)attribute).valueAsDouble();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public String targetValue() {
        return this.getAttributeValueAsString(this.targetAttribute.name());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Example example = (Example)object;
        return this.attributes.equals(example.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public Example numerize(Hashtable<String, Hashtable<String, Integer>> hashtable) {
        Hashtable<String, Attribute> hashtable2 = new Hashtable<String, Attribute>();
        for (String string : this.attributes.keySet()) {
            Attribute attribute = this.attributes.get(string);
            if (attribute instanceof StringAttribute) {
                int n = hashtable.get(string).get(attribute.valueAsString());
                NumericAttributeSpecification numericAttributeSpecification = new NumericAttributeSpecification(string);
                hashtable2.put(string, new NumericAttribute(n, numericAttributeSpecification));
                continue;
            }
            hashtable2.put(string, attribute);
        }
        return new Example(hashtable2, (Attribute)hashtable2.get(this.targetAttribute.name()));
    }
}

