/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.inductive;

import aima.learning.framework.Example;
import aima.learning.inductive.DLTest;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DecisionList {
    private String positive;
    private String negative;
    private List<DLTest> tests;
    private Hashtable<DLTest, String> testOutcomes;

    public DecisionList(String string, String string2) {
        this.positive = string;
        this.negative = string2;
        this.tests = new ArrayList<DLTest>();
        this.testOutcomes = new Hashtable();
    }

    public String predict(Example example) {
        if (this.tests.size() == 0) {
            return this.negative;
        }
        for (DLTest dLTest : this.tests) {
            if (!dLTest.matches(example)) continue;
            return this.testOutcomes.get(dLTest);
        }
        return this.negative;
    }

    public void add(DLTest dLTest, String string) {
        this.tests.add(dLTest);
        this.testOutcomes.put(dLTest, string);
    }

    public DecisionList mergeWith(DecisionList decisionList) {
        DecisionList decisionList2 = new DecisionList(this.positive, this.negative);
        for (DLTest dLTest : this.tests) {
            decisionList2.add(dLTest, this.testOutcomes.get(dLTest));
        }
        for (DLTest dLTest : decisionList.tests) {
            decisionList2.add(dLTest, decisionList.testOutcomes.get(dLTest));
        }
        return decisionList2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (DLTest dLTest : this.tests) {
            stringBuffer.append(dLTest.toString() + " => " + this.testOutcomes.get(dLTest) + " ELSE \n");
        }
        stringBuffer.append("END");
        return stringBuffer.toString();
    }
}

