/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.knowledge;

import aima.learning.framework.DataSetSpecification;
import aima.logic.fol.domain.FOLDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class FOLDataSetDomain
extends FOLDomain {
    private static Pattern allowableCharactersRegEx = Pattern.compile("[^a-zA-Z_$0-9]");
    private DataSetSpecification dataSetSpecification;
    private String trueGoalValue = null;
    private String examplePrefix = "X";
    private List<String> descriptionPredicateNames = new ArrayList<String>();
    private List<String> descriptionDataSetNames = new ArrayList<String>();
    private Map<String, String> dsToFOLNameMap = new HashMap<String, String>();

    public FOLDataSetDomain(DataSetSpecification dataSetSpecification, String string) {
        this.dataSetSpecification = dataSetSpecification;
        this.trueGoalValue = string;
        this.constructFOLDomain();
    }

    public String getDataSetTargetName() {
        return this.dataSetSpecification.getTarget();
    }

    public String getGoalPredicateName() {
        return this.getFOLName(this.dataSetSpecification.getTarget());
    }

    public String getTrueGoalValue() {
        return this.trueGoalValue;
    }

    public List<String> getDescriptionPredicateNames() {
        return this.descriptionPredicateNames;
    }

    public List<String> getDescriptionDataSetNames() {
        return this.descriptionDataSetNames;
    }

    public boolean isMultivalued(String string) {
        List<String> list = this.dataSetSpecification.getPossibleAttributeValues(string);
        if (list.size() > 2) {
            return true;
        }
        for (String string2 : list) {
            if (!this.trueGoalValue.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public String getExampleConstant(int n) {
        String string = this.examplePrefix + n;
        this.addConstant(string);
        return string;
    }

    public String getFOLName(String string) {
        String string2 = this.dsToFOLNameMap.get(string);
        if (null == string2) {
            string2 = string;
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                string2 = "_" + string;
            }
            string2 = allowableCharactersRegEx.matcher(string2).replaceAll("_");
            this.dsToFOLNameMap.put(string, string2);
        }
        return string2;
    }

    private void constructFOLDomain() {
        this.addPredicate(this.getFOLName(this.dataSetSpecification.getTarget()));
        for (String string : this.dataSetSpecification.getNamesOfStringAttributes()) {
            if (this.dataSetSpecification.getTarget().equals(string)) continue;
            String string2 = this.getFOLName(string);
            this.addPredicate(string2);
            this.descriptionPredicateNames.add(string2);
            this.descriptionDataSetNames.add(string);
            List<String> list = this.dataSetSpecification.getPossibleAttributeValues(string);
            if (!this.isMultivalued(string)) continue;
            for (String string3 : list) {
                this.addConstant(this.getFOLName(string3));
            }
        }
    }
}

