/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.learners;

import aima.learning.framework.DataSet;
import aima.learning.framework.Example;
import aima.learning.framework.Learner;
import aima.learning.inductive.DLTest;
import aima.learning.inductive.DLTestFactory;
import aima.learning.inductive.DecisionList;
import java.util.List;

public class DecisionListLearner
implements Learner {
    public static final String FAILURE = "Failure";
    private DecisionList decisionList;
    private String positive;
    private String negative;
    private DLTestFactory testFactory;

    public DecisionListLearner(String string, String string2, DLTestFactory dLTestFactory) {
        this.positive = string;
        this.negative = string2;
        this.testFactory = dLTestFactory;
    }

    @Override
    public void train(DataSet dataSet) {
        this.decisionList = this.decisionListLearning(dataSet);
    }

    @Override
    public String predict(Example example) {
        if (this.decisionList == null) {
            throw new RuntimeException("learner has not been trained with dataset yet!");
        }
        return this.decisionList.predict(example);
    }

    @Override
    public int[] test(DataSet dataSet) {
        int[] nArray = new int[]{0, 0};
        for (Example example : dataSet.examples) {
            if (example.targetValue().equals(this.decisionList.predict(example))) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    private DecisionList decisionListLearning(DataSet dataSet) {
        if (dataSet.size() == 0) {
            return new DecisionList(this.positive, this.negative);
        }
        List<DLTest> list = this.testFactory.createDLTestsWithAttributeCount(dataSet, 1);
        DLTest dLTest = this.getValidTest(list, dataSet);
        if (dLTest == null) {
            return new DecisionList(null, FAILURE);
        }
        DataSet dataSet2 = dLTest.matchedExamples(dataSet);
        DecisionList decisionList = new DecisionList(this.positive, this.negative);
        decisionList.add(dLTest, dataSet2.getExample(0).targetValue());
        return decisionList.mergeWith(this.decisionListLearning(dLTest.unmatchedExamples(dataSet)));
    }

    private DLTest getValidTest(List<DLTest> list, DataSet dataSet) {
        for (DLTest dLTest : list) {
            DataSet dataSet2 = dLTest.matchedExamples(dataSet);
            if (dataSet2.size() == 0 || !this.allExamplesHaveSameTargetValue(dataSet2)) continue;
            return dLTest;
        }
        return null;
    }

    private boolean allExamplesHaveSameTargetValue(DataSet dataSet) {
        String string = dataSet.getExample(0).targetValue();
        for (Example example : dataSet.examples) {
            if (example.targetValue().equals(string)) continue;
            return false;
        }
        return true;
    }

    public DecisionList getDecisionList() {
        return this.decisionList;
    }
}

