/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.neural;

import aima.learning.neural.FunctionApproximator;
import aima.learning.neural.HardLimitActivationFunction;
import aima.learning.neural.Layer;
import aima.learning.neural.NNDataSet;
import aima.learning.neural.NNExample;
import aima.learning.neural.Vector;
import aima.util.Matrix;

public class Perceptron
implements FunctionApproximator {
    private final Layer layer;
    private Vector lastInput;

    public Perceptron(int n, int n2) {
        this.layer = new Layer(n, n2, 2.0, -2.0, new HardLimitActivationFunction());
    }

    @Override
    public Vector processInput(Vector vector) {
        this.lastInput = vector;
        return this.layer.feedForward(vector);
    }

    @Override
    public void processError(Vector vector) {
        Matrix matrix = vector.times(this.lastInput.transpose());
        this.layer.acceptNewWeightUpdate(matrix);
        Vector vector2 = this.layer.getBiasVector().plus(vector);
        this.layer.acceptNewBiasUpdate(vector2);
    }

    public void trainOn(NNDataSet nNDataSet, int n) {
        for (int i = 0; i < n; ++i) {
            nNDataSet.refreshDataset();
            while (nNDataSet.hasMoreExamples()) {
                NNExample nNExample = nNDataSet.getExampleAtRandom();
                this.processInput(nNExample.getInput());
                Vector vector = this.layer.errorVectorFrom(nNExample.getTarget());
                this.processError(vector);
            }
        }
    }

    public Vector predict(NNExample nNExample) {
        return this.processInput(nNExample.getInput());
    }

    public int[] testOnDataSet(NNDataSet nNDataSet) {
        int[] nArray = new int[]{0, 0};
        nNDataSet.refreshDataset();
        while (nNDataSet.hasMoreExamples()) {
            Vector vector;
            NNExample nNExample = nNDataSet.getExampleAtRandom();
            if (nNExample.isCorrect(vector = this.predict(nNExample))) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }
}

