/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.Connectors;
import aima.logic.fol.kb.data.CNF;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

class CNFConstructor
implements FOLVisitor {
    public CNF construct(Sentence sentence) {
        ArgData argData = new ArgData();
        sentence.accept(this, argData);
        return new CNF(argData.clauses);
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object object) {
        ArgData argData = (ArgData)object;
        if (argData.negated) {
            argData.clauses.get(argData.clauses.size() - 1).addNegativeLiteral(predicate);
        } else {
            argData.clauses.get(argData.clauses.size() - 1).addPositiveLiteral(predicate);
        }
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality termEquality, Object object) {
        ArgData argData = (ArgData)object;
        if (argData.negated) {
            argData.clauses.get(argData.clauses.size() - 1).addNegativeLiteral(termEquality);
        } else {
            argData.clauses.get(argData.clauses.size() - 1).addPositiveLiteral(termEquality);
        }
        return termEquality;
    }

    @Override
    public Object visitVariable(Variable variable, Object object) {
        throw new IllegalStateException("visitVariable() should not be called.");
    }

    @Override
    public Object visitConstant(Constant constant, Object object) {
        throw new IllegalStateException("visitConstant() should not be called.");
    }

    @Override
    public Object visitFunction(Function function, Object object) {
        throw new IllegalStateException("visitFunction() should not be called.");
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object object) {
        ArgData argData = (ArgData)object;
        argData.negated = true;
        notSentence.getNegated().accept(this, object);
        argData.negated = false;
        return notSentence;
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
        ArgData argData = (ArgData)object;
        Sentence sentence = connectedSentence.getFirst();
        Sentence sentence2 = connectedSentence.getSecond();
        sentence.accept(this, object);
        if (Connectors.isAND(connectedSentence.getConnector())) {
            argData.clauses.add(new Clause());
        }
        sentence2.accept(this, object);
        return connectedSentence;
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
        throw new IllegalStateException("All quantified sentences should have already been removed.");
    }

    class ArgData {
        public List<Clause> clauses = new ArrayList<Clause>();
        public boolean negated = false;

        public ArgData() {
            this.clauses.add(new Clause());
        }
    }
}

