/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.Quantifiers;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

class RemoveQuantifiers
implements FOLVisitor {
    private FOLParser parser = null;
    private SubstVisitor substVisitor = null;

    public RemoveQuantifiers(FOLParser fOLParser) {
        this.parser = fOLParser;
        this.substVisitor = new SubstVisitor();
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object object) {
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality termEquality, Object object) {
        return termEquality;
    }

    @Override
    public Object visitVariable(Variable variable, Object object) {
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object object) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object object) {
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object object) {
        return new NotSentence((Sentence)notSentence.getNegated().accept(this, object));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
        return new ConnectedSentence(connectedSentence.getConnector(), (Sentence)connectedSentence.getFirst().accept(this, object), (Sentence)connectedSentence.getSecond().accept(this, object));
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
        Sentence sentence = quantifiedSentence.getQuantified();
        Set set = (Set)object;
        if (Quantifiers.isEXISTS(quantifiedSentence.getQuantifier())) {
            LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
            for (Variable variable : quantifiedSentence.getVariables()) {
                String string;
                if (set.size() > 0) {
                    string = this.parser.getFOLDomain().addSkolemFunction();
                    linkedHashMap.put(variable, new Function(string, new ArrayList<Term>(set)));
                    continue;
                }
                string = this.parser.getFOLDomain().addSkolemConstant();
                linkedHashMap.put(variable, new Constant(string));
            }
            Sentence sentence2 = this.substVisitor.subst(linkedHashMap, sentence);
            return (Sentence)sentence2.accept(this, object);
        }
        if (Quantifiers.isFORALL(quantifiedSentence.getQuantifier())) {
            set.addAll(quantifiedSentence.getVariables());
            Sentence sentence3 = (Sentence)sentence.accept(this, object);
            set.removeAll(quantifiedSentence.getVariables());
            return sentence3;
        }
        throw new IllegalStateException("Unhandled Quantifier:" + quantifiedSentence.getQuantifier());
    }
}

