/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.parsing.ast.FOLNode;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Unifier {
    private static SubstVisitor _substVisitor = new SubstVisitor();
    private static VariableCollector _variableCollector = new VariableCollector();

    public Map<Variable, Term> unify(FOLNode fOLNode, FOLNode fOLNode2) {
        return this.unify(fOLNode, fOLNode2, new LinkedHashMap<Variable, Term>());
    }

    public Map<Variable, Term> unify(FOLNode fOLNode, FOLNode fOLNode2, Map<Variable, Term> map) {
        if (map == null) {
            return null;
        }
        if (fOLNode.equals(fOLNode2)) {
            return map;
        }
        if (fOLNode instanceof Variable) {
            return this.unifyVar((Variable)fOLNode, fOLNode2, map);
        }
        if (fOLNode2 instanceof Variable) {
            return this.unifyVar((Variable)fOLNode2, fOLNode, map);
        }
        if (this.isCompound(fOLNode) && this.isCompound(fOLNode2)) {
            return this.unify(this.args(fOLNode), this.args(fOLNode2), this.unifyOps(this.op(fOLNode), this.op(fOLNode2), map));
        }
        return null;
    }

    public Map<Variable, Term> unify(List<? extends FOLNode> list, List<? extends FOLNode> list2, Map<Variable, Term> map) {
        if (map == null) {
            return null;
        }
        if (list.size() != list2.size()) {
            return null;
        }
        if (list.size() == 0 && list2.size() == 0) {
            return map;
        }
        if (list.size() == 1 && list2.size() == 1) {
            return this.unify(list.get(0), list2.get(0), map);
        }
        return this.unify(list.subList(1, list.size()), list2.subList(1, list2.size()), this.unify(list.get(0), list2.get(0), map));
    }

    protected boolean occurCheck(Map<Variable, Term> map, Variable variable, FOLNode fOLNode) {
        if (fOLNode instanceof Function) {
            Set<Variable> set = _variableCollector.collectAllVariables((Function)fOLNode);
            if (set.contains(variable)) {
                return true;
            }
            return this.cascadeOccurCheck(map, variable, set, new HashSet<Variable>(set));
        }
        return false;
    }

    private Map<Variable, Term> unifyVar(Variable variable, FOLNode fOLNode, Map<Variable, Term> map) {
        if (!Term.class.isInstance(fOLNode)) {
            return null;
        }
        if (map.keySet().contains(variable)) {
            return this.unify(map.get(variable), fOLNode, map);
        }
        if (map.keySet().contains(fOLNode)) {
            return this.unify(variable, map.get(fOLNode), map);
        }
        if (this.occurCheck(map, variable, fOLNode)) {
            return null;
        }
        this.cascadeSubstitution(map, variable, (Term)fOLNode);
        return map;
    }

    private Map<Variable, Term> unifyOps(String string, String string2, Map<Variable, Term> map) {
        if (map == null) {
            return null;
        }
        if (string.equals(string2)) {
            return map;
        }
        return null;
    }

    private List<? extends FOLNode> args(FOLNode fOLNode) {
        return fOLNode.getArgs();
    }

    private String op(FOLNode fOLNode) {
        return fOLNode.getSymbolicName();
    }

    private boolean isCompound(FOLNode fOLNode) {
        return fOLNode.isCompound();
    }

    private boolean cascadeOccurCheck(Map<Variable, Term> map, Variable variable, Set<Variable> set, Set<Variable> set2) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (Variable variable2 : set) {
            Term term = map.get(variable2);
            if (null == term) continue;
            if (term.equals(variable)) {
                return true;
            }
            if (!(term instanceof Function)) continue;
            Set<Variable> set3 = _variableCollector.collectAllVariables((Function)term);
            if (set3.contains(variable)) {
                return true;
            }
            for (Variable variable3 : set3) {
                if (set2.contains(variable3)) continue;
                hashSet.add(variable3);
            }
        }
        if (hashSet.size() > 0) {
            set2.addAll(hashSet);
            return this.cascadeOccurCheck(map, variable, hashSet, set2);
        }
        return false;
    }

    private void cascadeSubstitution(Map<Variable, Term> map, Variable variable, Term term) {
        map.put(variable, term);
        for (Variable variable2 : map.keySet()) {
            Term term2 = map.get(variable2);
            map.put(variable2, _substVisitor.subst(map, term2));
        }
    }
}

