/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.Unifier;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class AbstractModulation {
    protected VariableCollector variableCollector = new VariableCollector();
    protected Unifier unifier = new Unifier();
    protected SubstVisitor substVisitor = new SubstVisitor();

    protected abstract boolean isValidMatch(Term var1, Set<Variable> var2, Term var3, Map<Variable, Term> var4);

    protected IdentifyCandidateMatchingTerm getMatchingSubstitution(Term term, AtomicSentence atomicSentence) {
        IdentifyCandidateMatchingTerm identifyCandidateMatchingTerm = new IdentifyCandidateMatchingTerm(term, atomicSentence);
        if (identifyCandidateMatchingTerm.isMatch()) {
            return identifyCandidateMatchingTerm;
        }
        return null;
    }

    protected class ReplaceMatchingTerm
    implements FOLVisitor {
        private Term toReplace = null;
        private Term replaceWith = null;
        private boolean replaced = false;

        public AtomicSentence replace(AtomicSentence atomicSentence, Term term, Term term2) {
            this.toReplace = term;
            this.replaceWith = term2;
            return (AtomicSentence)atomicSentence.accept(this, null);
        }

        @Override
        public Object visitPredicate(Predicate predicate, Object object) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Term term : predicate.getTerms()) {
                Term term2 = (Term)term.accept(this, object);
                arrayList.add(term2);
            }
            return new Predicate(predicate.getPredicateName(), arrayList);
        }

        @Override
        public Object visitTermEquality(TermEquality termEquality, Object object) {
            Term term = (Term)termEquality.getTerm1().accept(this, object);
            Term term2 = (Term)termEquality.getTerm2().accept(this, object);
            return new TermEquality(term, term2);
        }

        @Override
        public Object visitVariable(Variable variable, Object object) {
            if (!this.replaced && this.toReplace.equals(variable)) {
                this.replaced = true;
                return this.replaceWith;
            }
            return variable;
        }

        @Override
        public Object visitConstant(Constant constant, Object object) {
            if (!this.replaced && this.toReplace.equals(constant)) {
                this.replaced = true;
                return this.replaceWith;
            }
            return constant;
        }

        @Override
        public Object visitFunction(Function function, Object object) {
            if (!this.replaced && this.toReplace.equals(function)) {
                this.replaced = true;
                return this.replaceWith;
            }
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (Term term : function.getTerms()) {
                Term term2 = (Term)term.accept(this, object);
                arrayList.add(term2);
            }
            return new Function(function.getFunctionName(), arrayList);
        }

        @Override
        public Object visitNotSentence(NotSentence notSentence, Object object) {
            throw new IllegalStateException("visitNotSentence() should not be called.");
        }

        @Override
        public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
            throw new IllegalStateException("visitConnectedSentence() should not be called.");
        }

        @Override
        public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
            throw new IllegalStateException("visitQuantifiedSentence() should not be called.");
        }
    }

    protected class IdentifyCandidateMatchingTerm
    implements FOLVisitor {
        private Term toMatch = null;
        private Set<Variable> toMatchVariables = null;
        private Term matchingTerm = null;
        private Map<Variable, Term> substitution = null;

        public IdentifyCandidateMatchingTerm(Term term, AtomicSentence atomicSentence) {
            this.toMatch = term;
            this.toMatchVariables = AbstractModulation.this.variableCollector.collectAllVariables(term);
            atomicSentence.accept(this, null);
        }

        public boolean isMatch() {
            return null != this.matchingTerm;
        }

        public Term getMatchingTerm() {
            return this.matchingTerm;
        }

        public Map<Variable, Term> getMatchingSubstitution() {
            return this.substitution;
        }

        @Override
        public Object visitPredicate(Predicate predicate, Object object) {
            for (Term term : predicate.getArgs()) {
                if (null != this.matchingTerm) break;
                term.accept(this, null);
            }
            return predicate;
        }

        @Override
        public Object visitTermEquality(TermEquality termEquality, Object object) {
            for (Term term : termEquality.getArgs()) {
                if (null != this.matchingTerm) break;
                term.accept(this, null);
            }
            return termEquality;
        }

        @Override
        public Object visitVariable(Variable variable, Object object) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, variable);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, variable, this.substitution)) {
                this.matchingTerm = variable;
            }
            return variable;
        }

        @Override
        public Object visitConstant(Constant constant, Object object) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, constant);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, constant, this.substitution)) {
                this.matchingTerm = constant;
            }
            return constant;
        }

        @Override
        public Object visitFunction(Function function, Object object) {
            this.substitution = AbstractModulation.this.unifier.unify(this.toMatch, function);
            if (null != this.substitution && AbstractModulation.this.isValidMatch(this.toMatch, this.toMatchVariables, function, this.substitution)) {
                this.matchingTerm = function;
            }
            if (null == this.matchingTerm) {
                for (Term term : function.getArgs()) {
                    if (null != this.matchingTerm) break;
                    term.accept(this, null);
                }
            }
            return function;
        }

        @Override
        public Object visitNotSentence(NotSentence notSentence, Object object) {
            throw new IllegalStateException("visitNotSentence() should not be called.");
        }

        @Override
        public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
            throw new IllegalStateException("visitConnectedSentence() should not be called.");
        }

        @Override
        public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
            throw new IllegalStateException("visitQuantifiedSentence() should not be called.");
        }
    }
}

