/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.inference.proof.ProofStepFoChAlreadyAFact;
import aima.logic.fol.inference.proof.ProofStepFoChAssertFact;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLFCAsk
implements InferenceProcedure {
    @Override
    public InferenceResult ask(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence) {
        if (!(sentence instanceof AtomicSentence)) {
            throw new IllegalArgumentException("Only Atomic Queries are supported.");
        }
        FCAskAnswerHandler fCAskAnswerHandler = new FCAskAnswerHandler();
        Literal literal = new Literal((AtomicSentence)sentence);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        Set<Map<Variable, Term>> set = fOLKnowledgeBase.fetch(literal);
        if (set.size() > 0) {
            fCAskAnswerHandler.addProofStep(new ProofStepFoChAlreadyAFact(literal));
            fCAskAnswerHandler.setAnswers(set);
            return fCAskAnswerHandler;
        }
        do {
            arrayList.clear();
            for (Clause clause : fOLKnowledgeBase.getAllDefiniteClauseImplications()) {
                Clause clause2 = fOLKnowledgeBase.standardizeApart(clause);
                for (Map<Variable, Term> map : fOLKnowledgeBase.fetch(this.invert(clause2.getNegativeLiterals()))) {
                    Literal literal2 = fOLKnowledgeBase.subst(map, clause2.getPositiveLiterals().get(0));
                    if (fOLKnowledgeBase.isRenaming(literal2) || fOLKnowledgeBase.isRenaming(literal2, arrayList)) continue;
                    arrayList.add(literal2);
                    fCAskAnswerHandler.addProofStep(clause2, literal2, map);
                    map = fOLKnowledgeBase.unify(literal2.getAtomicSentence(), literal.getAtomicSentence());
                    if (null == map) continue;
                    for (Literal literal3 : arrayList) {
                        Sentence sentence2 = null;
                        sentence2 = literal3.isPositiveLiteral() ? literal3.getAtomicSentence() : new NotSentence(literal3.getAtomicSentence());
                        fOLKnowledgeBase.tell(sentence2);
                    }
                    fCAskAnswerHandler.setAnswers(fOLKnowledgeBase.fetch(literal));
                    return fCAskAnswerHandler;
                }
            }
            for (Literal literal4 : arrayList) {
                Object object = null;
                object = literal4.isPositiveLiteral() ? literal4.getAtomicSentence() : new NotSentence(literal4.getAtomicSentence());
                fOLKnowledgeBase.tell((Sentence)object);
            }
        } while (arrayList.size() > 0);
        return fCAskAnswerHandler;
    }

    private List<Literal> invert(List<Literal> list) {
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        for (Literal literal : list) {
            arrayList.add(new Literal(literal.getAtomicSentence(), literal.isPositiveLiteral()));
        }
        return arrayList;
    }

    class FCAskAnswerHandler
    implements InferenceResult {
        private ProofStep stepFinal = null;
        private List<Proof> proofs = new ArrayList<Proof>();

        @Override
        public boolean isPossiblyFalse() {
            return this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return false;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return false;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public void addProofStep(Clause clause, Literal literal, Map<Variable, Term> map) {
            this.stepFinal = new ProofStepFoChAssertFact(clause, literal, map, this.stepFinal);
        }

        public void addProofStep(ProofStep proofStep) {
            this.stepFinal = proofStep;
        }

        public void setAnswers(Set<Map<Variable, Term>> set) {
            for (Map<Variable, Term> map : set) {
                this.proofs.add(new ProofFinal(this.stepFinal, map));
            }
        }
    }
}

