/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.SubsumptionElimination;
import aima.logic.fol.Unifier;
import aima.logic.fol.inference.IndexedFarParents;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepChainCancellation;
import aima.logic.fol.inference.proof.ProofStepChainDropped;
import aima.logic.fol.inference.proof.ProofStepChainFromClause;
import aima.logic.fol.inference.proof.ProofStepGoal;
import aima.logic.fol.inference.trace.FOLModelEliminationTracer;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.kb.data.ReducedLiteral;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLModelElimination
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private FOLModelEliminationTracer tracer = null;
    private Unifier unifier = new Unifier();
    private SubstVisitor substVisitor = new SubstVisitor();

    public FOLModelElimination() {
    }

    public FOLModelElimination(long l) {
        this.setMaxQueryTime(l);
    }

    public FOLModelElimination(FOLModelEliminationTracer fOLModelEliminationTracer) {
        this.tracer = fOLModelEliminationTracer;
    }

    public FOLModelElimination(FOLModelEliminationTracer fOLModelEliminationTracer, long l) {
        this.tracer = fOLModelEliminationTracer;
        this.setMaxQueryTime(l);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long l) {
        this.maxQueryTime = l;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence) {
        LinkedHashSet<Clause> linkedHashSet = new LinkedHashSet<Clause>(fOLKnowledgeBase.getAllClauses());
        linkedHashSet.removeAll(SubsumptionElimination.findSubsumedClauses(linkedHashSet));
        List<Chain> list = this.createChainsFromClauses(linkedHashSet);
        AnswerHandler answerHandler = new AnswerHandler(fOLKnowledgeBase, sentence, this.maxQueryTime);
        IndexedFarParents indexedFarParents = new IndexedFarParents(answerHandler.getSetOfSupport(), list);
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            answerHandler.resetMaxDepthReached();
            if (null != this.tracer) {
                this.tracer.reset();
            }
            for (Chain chain : answerHandler.getSetOfSupport()) {
                this.recursiveDLS(i, 0, chain, indexedFarParents, answerHandler);
                if (!answerHandler.isComplete()) continue;
                return answerHandler;
            }
            if (answerHandler.getMaxDepthReached() >= i) continue;
            return answerHandler;
        }
        return answerHandler;
    }

    private List<Chain> createChainsFromClauses(Set<Clause> set) {
        ArrayList<Chain> arrayList = new ArrayList<Chain>();
        for (Clause clause : set) {
            Chain chain = new Chain(clause.getLiterals());
            chain.setProofStep(new ProofStepChainFromClause(chain, clause));
            arrayList.add(chain);
            arrayList.addAll(chain.getContrapositives());
        }
        return arrayList;
    }

    private void recursiveDLS(int n, int n2, Chain chain, IndexedFarParents indexedFarParents, AnswerHandler answerHandler) {
        answerHandler.updateMaxDepthReached(n2);
        if (n2 == n) {
            return;
        }
        int n3 = indexedFarParents.getNumberCandidateFarParents(chain);
        if (null != this.tracer) {
            this.tracer.increment(n2, n3);
        }
        indexedFarParents.standardizeApart(chain);
        for (int i = 0; i < n3 && !answerHandler.isComplete(); ++i) {
            Chain chain2 = indexedFarParents.attemptReduction(chain, i);
            if (null == chain2) continue;
            boolean bl = false;
            boolean bl2 = false;
            do {
                bl = false;
                Chain chain3 = null;
                while (chain2 != (chain3 = this.tryCancellation(chain2))) {
                    chain2 = chain3;
                    bl = true;
                }
                bl2 = false;
                while (chain2 != (chain3 = this.tryDropping(chain2))) {
                    chain2 = chain3;
                    bl2 = true;
                }
            } while (bl2 || bl);
            if (answerHandler.isAnswer(chain2)) continue;
            int n4 = indexedFarParents.getNumberFarParents(chain2);
            chain2 = indexedFarParents.addToIndex(chain2);
            this.recursiveDLS(n, n2 + 1, chain2, indexedFarParents, answerHandler);
            indexedFarParents.resetNumberFarParentsTo(chain2, n4);
        }
    }

    private Chain tryCancellation(Chain chain) {
        Literal literal = chain.getHead();
        if (null != literal && !(literal instanceof ReducedLiteral)) {
            for (Literal literal2 : chain.getTail()) {
                Map<Variable, Term> map;
                if (!(literal2 instanceof ReducedLiteral) || literal.isNegativeLiteral() == literal2.isNegativeLiteral() || null == (map = this.unifier.unify(literal.getAtomicSentence(), literal2.getAtomicSentence()))) continue;
                ArrayList<Literal> arrayList = new ArrayList<Literal>();
                for (Literal literal3 : chain.getTail()) {
                    AtomicSentence atomicSentence = (AtomicSentence)this.substVisitor.subst(map, literal3.getAtomicSentence());
                    arrayList.add(literal3.newInstance(atomicSentence));
                }
                Chain chain2 = new Chain(arrayList);
                chain2.setProofStep(new ProofStepChainCancellation(chain2, chain, map));
                return chain2;
            }
        }
        return chain;
    }

    private Chain tryDropping(Chain chain) {
        Literal literal = chain.getHead();
        if (null != literal && literal instanceof ReducedLiteral) {
            Chain chain2 = new Chain(chain.getTail());
            chain2.setProofStep(new ProofStepChainDropped(chain2, chain));
            return chain2;
        }
        return chain;
    }

    class AnswerHandler
    implements InferenceResult {
        private Chain answerChain = new Chain();
        private Set<Variable> answerLiteralVariables;
        private List<Chain> sos = null;
        private boolean complete = false;
        private long finishTime = 0L;
        private int maxDepthReached = 0;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public AnswerHandler(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence, long l) {
            this.finishTime = System.currentTimeMillis() + l;
            NotSentence notSentence = new NotSentence(sentence);
            Literal literal = fOLKnowledgeBase.createAnswerLiteral(notSentence);
            this.answerLiteralVariables = fOLKnowledgeBase.collectAllVariables(literal.getAtomicSentence());
            if (this.answerLiteralVariables.size() > 0) {
                ConnectedSentence connectedSentence = new ConnectedSentence("OR", notSentence, literal.getAtomicSentence().copy());
                this.sos = FOLModelElimination.this.createChainsFromClauses(fOLKnowledgeBase.convertToClauses(connectedSentence));
                this.answerChain.addLiteral(literal);
            } else {
                this.sos = FOLModelElimination.this.createChainsFromClauses(fOLKnowledgeBase.convertToClauses(notSentence));
            }
            for (Chain chain : this.sos) {
                chain.setProofStep(new ProofStepGoal(chain));
            }
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public List<Chain> getSetOfSupport() {
            return this.sos;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void resetMaxDepthReached() {
            this.maxDepthReached = 0;
        }

        public int getMaxDepthReached() {
            return this.maxDepthReached;
        }

        public void updateMaxDepthReached(int n) {
            if (n > this.maxDepthReached) {
                this.maxDepthReached = n;
            }
        }

        public boolean isAnswer(Chain chain) {
            boolean bl = false;
            if (this.answerChain.isEmpty()) {
                if (chain.isEmpty()) {
                    this.proofs.add(new ProofFinal(chain.getProofStep(), new HashMap<Variable, Term>()));
                    this.complete = true;
                    bl = true;
                }
            } else {
                if (chain.isEmpty()) {
                    throw new IllegalStateException("Generated an empty chain while looking for an answer, implies original KB is unsatisfiable");
                }
                if (1 == chain.getNumberLiterals() && chain.getHead().getAtomicSentence().getSymbolicName().equals(this.answerChain.getHead().getAtomicSentence().getSymbolicName())) {
                    HashMap<Variable, Term> hashMap = new HashMap<Variable, Term>();
                    List<Term> list = chain.getHead().getAtomicSentence().getArgs();
                    int n = 0;
                    for (Variable object : this.answerLiteralVariables) {
                        hashMap.put(object, list.get(n));
                        ++n;
                    }
                    boolean bl2 = true;
                    for (Proof proof : this.proofs) {
                        if (!((Object)proof.getAnswerBindings()).equals(hashMap)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        this.proofs.add(new ProofFinal(chain.getProofStep(), hashMap));
                    }
                    bl = true;
                }
            }
            if (System.currentTimeMillis() > this.finishTime) {
                this.complete = true;
                this.timedOut = true;
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("isComplete=" + this.complete);
            stringBuilder.append("\n");
            stringBuilder.append("result=" + this.proofs);
            return stringBuilder.toString();
        }
    }
}

