/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.SubsumptionElimination;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.Paramodulation;
import aima.logic.fol.inference.otter.ClauseFilter;
import aima.logic.fol.inference.otter.ClauseSimplifier;
import aima.logic.fol.inference.otter.LightestClauseHeuristic;
import aima.logic.fol.inference.otter.defaultimpl.DefaultClauseFilter;
import aima.logic.fol.inference.otter.defaultimpl.DefaultClauseSimplifier;
import aima.logic.fol.inference.otter.defaultimpl.DefaultLightestClauseHeuristic;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepGoal;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLOTTERLikeTheoremProver
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private boolean useParamodulation = true;
    private LightestClauseHeuristic lightestClauseHeuristic = new DefaultLightestClauseHeuristic();
    private ClauseFilter clauseFilter = new DefaultClauseFilter();
    private ClauseSimplifier clauseSimplifier = new DefaultClauseSimplifier();
    private Paramodulation paramodulation = new Paramodulation();

    public FOLOTTERLikeTheoremProver() {
    }

    public FOLOTTERLikeTheoremProver(long l) {
        this.setMaxQueryTime(l);
    }

    public FOLOTTERLikeTheoremProver(boolean bl) {
        this.setUseParamodulation(bl);
    }

    public FOLOTTERLikeTheoremProver(long l, boolean bl) {
        this.setMaxQueryTime(l);
        this.setUseParamodulation(bl);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long l) {
        this.maxQueryTime = l;
    }

    public boolean isUseParamodulation() {
        return this.useParamodulation;
    }

    public void setUseParamodulation(boolean bl) {
        this.useParamodulation = bl;
    }

    public LightestClauseHeuristic getLightestClauseHeuristic() {
        return this.lightestClauseHeuristic;
    }

    public void setLightestClauseHeuristic(LightestClauseHeuristic lightestClauseHeuristic) {
        this.lightestClauseHeuristic = lightestClauseHeuristic;
    }

    public ClauseFilter getClauseFilter() {
        return this.clauseFilter;
    }

    public void setClauseFilter(ClauseFilter clauseFilter) {
        this.clauseFilter = clauseFilter;
    }

    public ClauseSimplifier getClauseSimplifier() {
        return this.clauseSimplifier;
    }

    public void setClauseSimplifier(ClauseSimplifier clauseSimplifier) {
        this.clauseSimplifier = clauseSimplifier;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase fOLKnowledgeBase, Sentence sentence) {
        Object object;
        Object object3;
        HashSet<Clause> hashSet = new HashSet<Clause>();
        HashSet<Clause> hashSet2 = new HashSet<Clause>();
        for (Clause clause : fOLKnowledgeBase.getAllClauses()) {
            Clause object42 = fOLKnowledgeBase.standardizeApart(clause);
            object42.setStandardizedApartCheckNotRequired();
            hashSet2.addAll(object42.getFactors());
        }
        if (this.isUseParamodulation()) {
            object3 = new TermEquality(new Variable("x"), new Variable("x"));
            Clause clause = new Clause();
            clause.addLiteral(new Literal((AtomicSentence)object3));
            Clause clause2 = fOLKnowledgeBase.standardizeApart(clause);
            clause2.setStandardizedApartCheckNotRequired();
            hashSet2.add(clause2);
        }
        object3 = new NotSentence(sentence);
        Literal literal = fOLKnowledgeBase.createAnswerLiteral((Sentence)object3);
        Set<Variable> set = fOLKnowledgeBase.collectAllVariables(literal.getAtomicSentence());
        Clause clause = new Clause();
        if (set.size() > 0) {
            object = new ConnectedSentence("OR", (Sentence)object3, literal.getAtomicSentence());
            for (Clause clause3 : fOLKnowledgeBase.convertToClauses((Sentence)object)) {
                clause3 = fOLKnowledgeBase.standardizeApart(clause3);
                clause3.setProofStep(new ProofStepGoal(clause3));
                clause3.setStandardizedApartCheckNotRequired();
                hashSet.addAll(clause3.getFactors());
            }
            clause.addLiteral(literal);
        } else {
            for (Clause clause4 : fOLKnowledgeBase.convertToClauses((Sentence)object3)) {
                Clause clause5 = fOLKnowledgeBase.standardizeApart(clause4);
                clause5.setProofStep(new ProofStepGoal(clause5));
                clause5.setStandardizedApartCheckNotRequired();
                hashSet.addAll(clause5.getFactors());
            }
        }
        hashSet2.removeAll(SubsumptionElimination.findSubsumedClauses(hashSet2));
        hashSet.removeAll(SubsumptionElimination.findSubsumedClauses(hashSet));
        object = new OTTERAnswerHandler(literal, set, clause, this.maxQueryTime);
        IndexedClauses indexedClauses = new IndexedClauses(this.getLightestClauseHeuristic(), hashSet, hashSet2);
        return this.otter((OTTERAnswerHandler)object, indexedClauses, hashSet, hashSet2);
    }

    private InferenceResult otter(OTTERAnswerHandler oTTERAnswerHandler, IndexedClauses indexedClauses, Set<Clause> set, Set<Clause> set2) {
        this.getLightestClauseHeuristic().initialSOS(set);
        do {
            Clause clause;
            if (null == (clause = this.getLightestClauseHeuristic().getLightestClause())) continue;
            set.remove(clause);
            this.getLightestClauseHeuristic().removedClauseFromSOS(clause);
            set2.add(clause);
            this.process(oTTERAnswerHandler, indexedClauses, this.infer(clause, set2), set, set2);
        } while (set.size() != 0 && !oTTERAnswerHandler.isComplete());
        return oTTERAnswerHandler;
    }

    private Set<Clause> infer(Clause clause, Set<Clause> set) {
        LinkedHashSet<Clause> linkedHashSet = new LinkedHashSet<Clause>();
        for (Clause clause2 : set) {
            Set<Clause> set2 = clause.binaryResolvents(clause2);
            for (Clause clause3 : set2) {
                linkedHashSet.add(clause3);
            }
            if (!this.isUseParamodulation()) continue;
            Set<Clause> set3 = this.paramodulation.apply(clause, clause2, true);
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                Clause clause4 = (Clause)iterator.next();
                linkedHashSet.add(clause4);
            }
        }
        return this.getClauseFilter().filter(linkedHashSet);
    }

    private void process(OTTERAnswerHandler oTTERAnswerHandler, IndexedClauses indexedClauses, Set<Clause> set, Set<Clause> set2, Set<Clause> set3) {
        for (Clause clause : set) {
            clause = this.getClauseSimplifier().simplify(clause);
            if (clause.isTautology()) continue;
            if (!(oTTERAnswerHandler.isAnswer(clause) || set2.contains(clause) || set3.contains(clause))) {
                for (Clause clause2 : clause.getFactors()) {
                    if (set2.contains(clause2) || set3.contains(clause2)) continue;
                    indexedClauses.addClause(clause2, set2, set3);
                    this.lookForUnitRefutation(oTTERAnswerHandler, indexedClauses, clause2, set2, set3);
                }
            }
            if (!oTTERAnswerHandler.isComplete()) continue;
            break;
        }
    }

    private void lookForUnitRefutation(OTTERAnswerHandler oTTERAnswerHandler, IndexedClauses indexedClauses, Clause clause, Set<Clause> set, Set<Clause> set2) {
        Set<Clause> set3 = new LinkedHashSet<Clause>();
        if (oTTERAnswerHandler.isCheckForUnitRefutation(clause)) {
            for (Clause clause2 : set) {
                if (!clause2.isUnitClause()) continue;
                set3.add(clause2);
            }
            for (Clause clause2 : set2) {
                if (!clause2.isUnitClause()) continue;
                set3.add(clause2);
            }
        }
        if (set3.size() > 0) {
            set3 = this.infer(clause, set3);
            for (Clause clause2 : set3) {
                clause2 = this.getClauseSimplifier().simplify(clause2);
                if (clause2.isTautology()) continue;
                if (!(oTTERAnswerHandler.isAnswer(clause2) || set.contains(clause2) || set2.contains(clause2))) {
                    indexedClauses.addClause(clause2, set, set2);
                }
                if (!oTTERAnswerHandler.isComplete()) continue;
                break;
            }
        }
    }

    class OTTERAnswerHandler
    implements InferenceResult {
        private Literal answerLiteral = null;
        private Set<Variable> answerLiteralVariables = null;
        private Clause answerClause = null;
        private long finishTime = 0L;
        private boolean complete = false;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public OTTERAnswerHandler(Literal literal, Set<Variable> set, Clause clause, long l) {
            this.answerLiteral = literal;
            this.answerLiteralVariables = set;
            this.answerClause = clause;
            this.finishTime = System.currentTimeMillis() + l;
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isLookingForAnswerLiteral() {
            return !this.answerClause.isEmpty();
        }

        public boolean isCheckForUnitRefutation(Clause clause) {
            if (this.isLookingForAnswerLiteral()) {
                if (2 == clause.getNumberLiterals()) {
                    for (Literal literal : clause.getLiterals()) {
                        if (!literal.getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) continue;
                        return true;
                    }
                }
            } else {
                return clause.isUnitClause();
            }
            return false;
        }

        public boolean isAnswer(Clause clause) {
            boolean bl = false;
            if (this.answerClause.isEmpty()) {
                if (clause.isEmpty()) {
                    this.proofs.add(new ProofFinal(clause.getProofStep(), new HashMap<Variable, Term>()));
                    this.complete = true;
                    bl = true;
                }
            } else {
                if (clause.isEmpty()) {
                    throw new IllegalStateException("Generated an empty clause while looking for an answer, implies original KB or usable is unsatisfiable");
                }
                if (clause.isUnitClause() && clause.isDefiniteClause() && clause.getPositiveLiterals().get(0).getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) {
                    HashMap<Variable, Term> hashMap = new HashMap<Variable, Term>();
                    List<Term> list = clause.getPositiveLiterals().get(0).getAtomicSentence().getArgs();
                    int n = 0;
                    for (Variable object : this.answerLiteralVariables) {
                        hashMap.put(object, list.get(n));
                        ++n;
                    }
                    boolean bl2 = true;
                    for (Proof proof : this.proofs) {
                        if (!((Object)proof.getAnswerBindings()).equals(hashMap)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        this.proofs.add(new ProofFinal(clause.getProofStep(), hashMap));
                    }
                    bl = true;
                }
            }
            if (System.currentTimeMillis() > this.finishTime) {
                this.complete = true;
                this.timedOut = true;
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("isComplete=" + this.complete);
            stringBuilder.append("\n");
            stringBuilder.append("result=" + this.proofs);
            return stringBuilder.toString();
        }
    }

    class IndexedClauses {
        private LightestClauseHeuristic lightestClauseHeuristic = null;
        private Map<Integer, Set<Clause>> clausesGroupedBySize = new HashMap<Integer, Set<Clause>>();
        private int minNoLiterals = Integer.MAX_VALUE;
        private int maxNoLiterals = 0;

        public IndexedClauses(LightestClauseHeuristic lightestClauseHeuristic, Set<Clause> set, Set<Clause> set2) {
            this.lightestClauseHeuristic = lightestClauseHeuristic;
            for (Clause clause : set) {
                this.indexClause(clause);
            }
            for (Clause clause : set2) {
                this.indexClause(clause);
            }
        }

        public void addClause(Clause clause, Set<Clause> set, Set<Clause> set2) {
            boolean bl = true;
            for (int i = this.minNoLiterals; i < clause.getNumberLiterals(); ++i) {
                Set<Clause> set3 = this.clausesGroupedBySize.get(i);
                if (null != set3) {
                    for (Clause object : set3) {
                        if (!object.subsumes(clause)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) break;
            }
            if (bl) {
                set.add(clause);
                this.lightestClauseHeuristic.addedClauseToSOS(clause);
                this.indexClause(clause);
                HashSet<Clause> hashSet = new HashSet<Clause>();
                for (int i = clause.getNumberLiterals() + 1; i <= this.maxNoLiterals; ++i) {
                    hashSet.clear();
                    Set<Clause> set4 = this.clausesGroupedBySize.get(i);
                    if (null == set4) continue;
                    Iterator iterator = set4.iterator();
                    while (iterator.hasNext()) {
                        Clause clause2 = (Clause)iterator.next();
                        if (!clause.subsumes(clause2)) continue;
                        hashSet.add(clause2);
                        if (set.contains(clause2)) {
                            set.remove(clause2);
                            this.lightestClauseHeuristic.removedClauseFromSOS(clause2);
                        }
                        set2.remove(clause2);
                    }
                    set4.removeAll(hashSet);
                }
            }
        }

        private void indexClause(Clause clause) {
            Set<Clause> set;
            int n = clause.getNumberLiterals();
            if (n < this.minNoLiterals) {
                this.minNoLiterals = n;
            }
            if (n > this.maxNoLiterals) {
                this.maxNoLiterals = n;
            }
            if (null == (set = this.clausesGroupedBySize.get(n))) {
                set = new HashSet<Clause>();
                this.clausesGroupedBySize.put(n, set);
            }
            set.add(clause);
        }
    }
}

