/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.StandardizeApartInPlace;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.Unifier;
import aima.logic.fol.inference.proof.ProofStepChainReduction;
import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.kb.data.ReducedLiteral;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class IndexedFarParents {
    private int saIdx = 0;
    private Unifier unifier = new Unifier();
    private SubstVisitor substVisitor = new SubstVisitor();
    private Map<String, List<Chain>> posHeads = new LinkedHashMap<String, List<Chain>>();
    private Map<String, List<Chain>> negHeads = new LinkedHashMap<String, List<Chain>>();

    public IndexedFarParents(List<Chain> list, List<Chain> list2) {
        this.constructInternalDataStructures(list, list2);
    }

    public int getNumberFarParents(Chain chain) {
        String string;
        Literal literal = chain.getHead();
        Map<String, List<Chain>> map = null;
        map = literal.isPositiveLiteral() ? this.posHeads : this.negHeads;
        List<Chain> list = map.get(string = literal.getAtomicSentence().getSymbolicName());
        if (null != list) {
            return list.size();
        }
        return 0;
    }

    public void resetNumberFarParentsTo(Chain chain, int n) {
        Literal literal = chain.getHead();
        Map<String, List<Chain>> map = null;
        map = literal.isPositiveLiteral() ? this.posHeads : this.negHeads;
        String string = literal.getAtomicSentence().getSymbolicName();
        List<Chain> list = map.get(string);
        while (list.size() > n) {
            list.remove(list.size() - 1);
        }
    }

    public int getNumberCandidateFarParents(Chain chain) {
        String string;
        Literal literal = chain.getHead();
        Map<String, List<Chain>> map = null;
        map = literal.isPositiveLiteral() ? this.negHeads : this.posHeads;
        List<Chain> list = map.get(string = literal.getAtomicSentence().getSymbolicName());
        if (null != list) {
            return list.size();
        }
        return 0;
    }

    public Chain attemptReduction(Chain chain, int n) {
        AtomicSentence atomicSentence;
        String string;
        Chain chain2 = null;
        Literal literal = chain.getHead();
        Map<String, List<Chain>> map = null;
        map = literal.isPositiveLiteral() ? this.negHeads : this.posHeads;
        List<Chain> list = map.get(string = (atomicSentence = literal.getAtomicSentence()).getSymbolicName());
        if (null != list) {
            Chain chain3 = list.get(n);
            this.standardizeApart(chain3);
            Literal literal2 = chain3.getHead();
            AtomicSentence atomicSentence2 = literal2.getAtomicSentence();
            Map<Variable, Term> map2 = this.unifier.unify(atomicSentence, atomicSentence2);
            if (null != map2) {
                AtomicSentence atomicSentence3;
                Chain chain4 = chain3;
                Literal literal3 = literal;
                Chain chain5 = chain;
                ArrayList<Literal> arrayList = new ArrayList<Literal>();
                for (Literal literal4 : chain4.getTail()) {
                    atomicSentence3 = (AtomicSentence)this.substVisitor.subst(map2, literal4.getAtomicSentence());
                    arrayList.add(literal4.newInstance(atomicSentence3));
                }
                arrayList.add(new ReducedLiteral((AtomicSentence)this.substVisitor.subst(map2, literal3.getAtomicSentence()), literal3.isNegativeLiteral()));
                for (Literal literal4 : chain5.getTail()) {
                    atomicSentence3 = (AtomicSentence)this.substVisitor.subst(map2, literal4.getAtomicSentence());
                    arrayList.add(literal4.newInstance(atomicSentence3));
                }
                chain2 = new Chain(arrayList);
                chain2.setProofStep(new ProofStepChainReduction(chain2, chain, chain3, map2));
            }
        }
        return chain2;
    }

    public Chain addToIndex(Chain chain) {
        Chain chain2 = null;
        Literal literal = chain.getHead();
        if (null != literal) {
            String string;
            Map<String, List<Chain>> map = null;
            map = literal.isPositiveLiteral() ? this.posHeads : this.negHeads;
            List<Chain> list = map.get(string = literal.getAtomicSentence().getSymbolicName());
            if (null == list) {
                list = new ArrayList<Chain>();
                map.put(string, list);
            }
            chain2 = chain;
            list.add(chain2);
        }
        return chain2;
    }

    public void standardizeApart(Chain chain) {
        this.saIdx = StandardizeApartInPlace.standardizeApart(chain, this.saIdx);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        stringBuilder.append(this.posHeads.size());
        for (String string : this.posHeads.keySet()) {
            stringBuilder.append(",");
            stringBuilder.append(this.posHeads.get(string).size());
        }
        stringBuilder.append(" posHeads=");
        stringBuilder.append(this.posHeads.toString());
        stringBuilder.append("\n");
        stringBuilder.append("#");
        stringBuilder.append(this.negHeads.size());
        for (String string : this.negHeads.keySet()) {
            stringBuilder.append(",");
            stringBuilder.append(this.negHeads.get(string).size());
        }
        stringBuilder.append(" negHeads=");
        stringBuilder.append(this.negHeads.toString());
        return stringBuilder.toString();
    }

    private void constructInternalDataStructures(List<Chain> list, List<Chain> list2) {
        ArrayList<Chain> arrayList = new ArrayList<Chain>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        for (Chain chain : arrayList) {
            this.addToIndex(chain);
        }
    }
}

