/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference.proof;

import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofStep;
import java.util.List;

public class ProofPrinter {
    public static String printProof(Proof proof) {
        CharSequence charSequence;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Proof, Answer Bindings: ");
        stringBuilder.append(proof.getAnswerBindings());
        stringBuilder.append("\n");
        List<ProofStep> list = proof.getSteps();
        int n = "Step".length();
        int n2 = "Proof".length();
        int n3 = "Justification".length();
        for (ProofStep proofStep : list) {
            charSequence = "" + proofStep.getStepNumber();
            if (((String)charSequence).length() > n) {
                n = ((String)charSequence).length();
            }
            if (proofStep.getProof().length() > n2) {
                n2 = proofStep.getProof().length();
            }
            if (proofStep.getJustification().length() <= n3) continue;
            n3 = proofStep.getJustification().length();
        }
        String string = "|%-" + ++n + "s| %-" + ++n2 + "s|%-" + ++n3 + "s|\n";
        int n4 = 5 + n + n2 + n3;
        charSequence = new StringBuilder();
        for (int i = 0; i < n4; ++i) {
            ((StringBuilder)charSequence).append("-");
        }
        ((StringBuilder)charSequence).append("\n");
        stringBuilder.append(charSequence);
        stringBuilder.append(String.format(string, "Step", "Proof", "Justification"));
        stringBuilder.append(charSequence);
        for (ProofStep proofStep : list) {
            stringBuilder.append(String.format(string, "" + proofStep.getStepNumber(), proofStep.getProof(), proofStep.getJustification()));
        }
        stringBuilder.append(charSequence);
        return stringBuilder.toString();
    }
}

