/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb.data;

import aima.logic.fol.StandardizeApart;
import aima.logic.fol.StandardizeApartIndexical;
import aima.logic.fol.StandardizeApartIndexicalFactory;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.Unifier;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.inference.proof.ProofStepClauseBinaryResolvent;
import aima.logic.fol.inference.proof.ProofStepClauseFactor;
import aima.logic.fol.inference.proof.ProofStepPremise;
import aima.logic.fol.kb.data.ClauseEqualityIdentityConstructor;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.kb.data.LiteralsSorter;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import aima.util.MixedRadixNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Clause {
    private static StandardizeApartIndexical _saIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('c'));
    private static Unifier _unifier = new Unifier();
    private static SubstVisitor _substVisitor = new SubstVisitor();
    private static VariableCollector _variableCollector = new VariableCollector();
    private static StandardizeApart _standardizeApart = new StandardizeApart();
    private static LiteralsSorter _literalSorter = new LiteralsSorter();
    private final Set<Literal> literals = new LinkedHashSet<Literal>();
    private final List<Literal> positiveLiterals = new ArrayList<Literal>();
    private final List<Literal> negativeLiterals = new ArrayList<Literal>();
    private boolean immutable = false;
    private boolean saCheckRequired = true;
    private String equalityIdentity = "";
    private Set<Clause> factors = null;
    private Set<Clause> nonTrivialFactors = null;
    private String stringRep = null;
    private ProofStep proofStep = null;

    public Clause() {
    }

    public Clause(List<Literal> list) {
        this.literals.addAll(list);
        for (Literal literal : this.literals) {
            if (literal.isPositiveLiteral()) {
                this.positiveLiterals.add(literal);
                continue;
            }
            this.negativeLiterals.add(literal);
        }
        this.recalculateIdentity();
    }

    public Clause(List<Literal> list, List<Literal> list2) {
        this.literals.addAll(list);
        this.literals.addAll(list2);
        for (Literal literal : this.literals) {
            if (literal.isPositiveLiteral()) {
                this.positiveLiterals.add(literal);
                continue;
            }
            this.negativeLiterals.add(literal);
        }
        this.recalculateIdentity();
    }

    public ProofStep getProofStep() {
        if (null == this.proofStep) {
            this.proofStep = new ProofStepPremise(this);
        }
        return this.proofStep;
    }

    public void setProofStep(ProofStep proofStep) {
        this.proofStep = proofStep;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public boolean isStandardizedApartCheckRequired() {
        return this.saCheckRequired;
    }

    public void setStandardizedApartCheckNotRequired() {
        this.saCheckRequired = false;
    }

    public boolean isEmpty() {
        return this.literals.size() == 0;
    }

    public boolean isUnitClause() {
        return this.literals.size() == 1;
    }

    public boolean isDefiniteClause() {
        return !this.isEmpty() && this.positiveLiterals.size() == 1;
    }

    public boolean isImplicationDefiniteClause() {
        return this.isDefiniteClause() && this.negativeLiterals.size() >= 1;
    }

    public boolean isHornClause() {
        return !this.isEmpty() && this.positiveLiterals.size() <= 1;
    }

    public boolean isTautology() {
        for (Literal literal : this.positiveLiterals) {
            for (Literal literal2 : this.negativeLiterals) {
                if (!literal.getAtomicSentence().equals(literal2.getAtomicSentence())) continue;
                return true;
            }
        }
        return false;
    }

    public void addLiteral(Literal literal) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Clause is immutable, cannot be updated.");
        }
        int n = this.literals.size();
        this.literals.add(literal);
        if (this.literals.size() > n) {
            if (literal.isPositiveLiteral()) {
                this.positiveLiterals.add(literal);
            } else {
                this.negativeLiterals.add(literal);
            }
        }
        this.recalculateIdentity();
    }

    public void addPositiveLiteral(AtomicSentence atomicSentence) {
        this.addLiteral(new Literal(atomicSentence));
    }

    public void addNegativeLiteral(AtomicSentence atomicSentence) {
        this.addLiteral(new Literal(atomicSentence, true));
    }

    public int getNumberLiterals() {
        return this.literals.size();
    }

    public int getNumberPositiveLiterals() {
        return this.positiveLiterals.size();
    }

    public int getNumberNegativeLiterals() {
        return this.negativeLiterals.size();
    }

    public Set<Literal> getLiterals() {
        return Collections.unmodifiableSet(this.literals);
    }

    public List<Literal> getPositiveLiterals() {
        return Collections.unmodifiableList(this.positiveLiterals);
    }

    public List<Literal> getNegativeLiterals() {
        return Collections.unmodifiableList(this.negativeLiterals);
    }

    public Set<Clause> getFactors() {
        if (null == this.factors) {
            this.calculateFactors(null);
        }
        return Collections.unmodifiableSet(this.factors);
    }

    public Set<Clause> getNonTrivialFactors() {
        if (null == this.nonTrivialFactors) {
            this.calculateFactors(null);
        }
        return Collections.unmodifiableSet(this.nonTrivialFactors);
    }

    public boolean subsumes(Clause clause) {
        boolean bl = false;
        if (this != clause && this.getNumberLiterals() < clause.getNumberLiterals() && this.getNumberPositiveLiterals() <= clause.getNumberPositiveLiterals() && this.getNumberNegativeLiterals() <= clause.getNumberNegativeLiterals()) {
            Map<String, List<Literal>> map = this.collectLikeLiterals(this.literals);
            Map<String, List<Literal>> map2 = this.collectLikeLiterals(clause.literals);
            if (map2.keySet().containsAll(map.keySet())) {
                boolean bl2 = true;
                for (String string : map.keySet()) {
                    if (map.get(string).size() <= map2.get(string).size()) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    bl = this.checkSubsumes(clause, map, map2);
                }
            }
        }
        return bl;
    }

    public Set<Clause> binaryResolvents(Clause clause) {
        LinkedHashSet<Clause> linkedHashSet = new LinkedHashSet<Clause>();
        if (this.isEmpty() && clause.isEmpty()) {
            linkedHashSet.add(new Clause());
            return linkedHashSet;
        }
        clause = this.saIfRequired(clause);
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        ArrayList<Literal> arrayList2 = new ArrayList<Literal>();
        arrayList.addAll(this.positiveLiterals);
        arrayList.addAll(clause.positiveLiterals);
        arrayList2.addAll(this.negativeLiterals);
        arrayList2.addAll(clause.negativeLiterals);
        ArrayList<Literal> arrayList3 = new ArrayList<Literal>();
        ArrayList<Literal> arrayList4 = new ArrayList<Literal>();
        ArrayList<Literal> arrayList5 = new ArrayList<Literal>();
        ArrayList<Literal> arrayList6 = new ArrayList<Literal>();
        for (int i = 0; i < 2; ++i) {
            arrayList3.clear();
            arrayList4.clear();
            if (i == 0) {
                arrayList3.addAll(this.positiveLiterals);
                arrayList4.addAll(clause.negativeLiterals);
            } else {
                arrayList3.addAll(clause.positiveLiterals);
                arrayList4.addAll(this.negativeLiterals);
            }
            LinkedHashMap<Variable, Term> linkedHashMap = new LinkedHashMap<Variable, Term>();
            for (Literal literal : arrayList3) {
                for (Literal literal2 : arrayList4) {
                    linkedHashMap.clear();
                    if (null == _unifier.unify(literal.getAtomicSentence(), literal2.getAtomicSentence(), linkedHashMap)) continue;
                    arrayList5.clear();
                    arrayList6.clear();
                    boolean bl = false;
                    for (Literal literal3 : arrayList) {
                        if (!bl && literal.equals(literal3)) {
                            bl = true;
                            continue;
                        }
                        arrayList5.add(_substVisitor.subst(linkedHashMap, literal3));
                    }
                    bl = false;
                    for (Literal literal4 : arrayList2) {
                        if (!bl && literal2.equals(literal4)) {
                            bl = true;
                            continue;
                        }
                        arrayList6.add(_substVisitor.subst(linkedHashMap, literal4));
                    }
                    Map<Variable, Term> map = _standardizeApart.standardizeApart(arrayList5, arrayList6, _saIndexical);
                    Clause object2 = new Clause(arrayList5, arrayList6);
                    object2.setProofStep(new ProofStepClauseBinaryResolvent(object2, this, clause, linkedHashMap, map));
                    if (this.isImmutable()) {
                        object2.setImmutable();
                    }
                    if (!this.isStandardizedApartCheckRequired()) {
                        object2.setStandardizedApartCheckNotRequired();
                    }
                    linkedHashSet.add(object2);
                }
            }
        }
        return linkedHashSet;
    }

    public String toString() {
        if (null == this.stringRep) {
            ArrayList<Literal> arrayList = new ArrayList<Literal>(this.literals);
            Collections.sort(arrayList, _literalSorter);
            this.stringRep = ((Object)arrayList).toString();
        }
        return this.stringRep;
    }

    public int hashCode() {
        return this.equalityIdentity.hashCode();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Clause)) {
            return false;
        }
        Clause clause = (Clause)object;
        return this.equalityIdentity.equals(clause.equalityIdentity);
    }

    public String getEqualityIdentity() {
        return this.equalityIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateIdentity() {
        String string = this.equalityIdentity;
        synchronized (string) {
            ArrayList<Literal> arrayList = new ArrayList<Literal>(this.literals);
            Collections.sort(arrayList, _literalSorter);
            ClauseEqualityIdentityConstructor clauseEqualityIdentityConstructor = new ClauseEqualityIdentityConstructor(arrayList, _literalSorter);
            this.equalityIdentity = clauseEqualityIdentityConstructor.getIdentity();
            this.factors = null;
            this.nonTrivialFactors = null;
            this.stringRep = null;
        }
    }

    private void calculateFactors(Set<Clause> set) {
        this.nonTrivialFactors = new LinkedHashSet<Clause>();
        HashMap<Variable, Term> hashMap = new HashMap<Variable, Term>();
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        for (int i = 0; i < 2; ++i) {
            arrayList.clear();
            if (i == 0) {
                arrayList.addAll(this.positiveLiterals);
            } else {
                arrayList.addAll(this.negativeLiterals);
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                for (int k = j + 1; k < arrayList.size(); ++k) {
                    Literal literal = (Literal)arrayList.get(j);
                    Literal literal2 = (Literal)arrayList.get(k);
                    hashMap.clear();
                    Map<Variable, Term> map = _unifier.unify(literal.getAtomicSentence(), literal2.getAtomicSentence(), hashMap);
                    if (null == map) continue;
                    ArrayList<Literal> arrayList2 = new ArrayList<Literal>();
                    ArrayList<Literal> arrayList3 = new ArrayList<Literal>();
                    if (i == 0) {
                        arrayList2.add(_substVisitor.subst(map, literal));
                    } else {
                        arrayList3.add(_substVisitor.subst(map, literal));
                    }
                    for (Literal literal3 : this.positiveLiterals) {
                        if (literal3 == literal || literal3 == literal2) continue;
                        arrayList2.add(_substVisitor.subst(map, literal3));
                    }
                    for (Literal literal3 : this.negativeLiterals) {
                        if (literal3 == literal || literal3 == literal2) continue;
                        arrayList3.add(_substVisitor.subst(map, literal3));
                    }
                    _standardizeApart.standardizeApart(arrayList2, arrayList3, _saIndexical);
                    Clause clause = new Clause(arrayList2, arrayList3);
                    clause.setProofStep(new ProofStepClauseFactor(clause, this));
                    if (this.isImmutable()) {
                        clause.setImmutable();
                    }
                    if (!this.isStandardizedApartCheckRequired()) {
                        clause.setStandardizedApartCheckNotRequired();
                    }
                    if (null == set) {
                        super.calculateFactors(this.nonTrivialFactors);
                        this.nonTrivialFactors.addAll(clause.getFactors());
                        continue;
                    }
                    if (set.contains(clause)) continue;
                    super.calculateFactors(this.nonTrivialFactors);
                    this.nonTrivialFactors.addAll(clause.getFactors());
                }
            }
        }
        this.factors = new LinkedHashSet<Clause>();
        this.factors.add(this);
        this.factors.addAll(this.nonTrivialFactors);
    }

    private Clause saIfRequired(Clause clause) {
        if (this.isStandardizedApartCheckRequired() || this == clause) {
            Set<Variable> set = _variableCollector.collectAllVariables(this);
            Set<Variable> set2 = _variableCollector.collectAllVariables(clause);
            HashSet<Variable> hashSet = new HashSet<Variable>();
            hashSet.addAll(set);
            hashSet.addAll(set2);
            if (hashSet.size() < set.size() + set2.size()) {
                clause = _standardizeApart.standardizeApart(clause, _saIndexical);
            }
        }
        return clause;
    }

    private Map<String, List<Literal>> collectLikeLiterals(Set<Literal> set) {
        HashMap<String, List<Literal>> hashMap = new HashMap<String, List<Literal>>();
        for (Literal literal : set) {
            String string = (literal.isNegativeLiteral() ? "~" : "") + literal.getAtomicSentence().getSymbolicName() + "/" + literal.getAtomicSentence().getArgs().size();
            ArrayList<Literal> arrayList = (ArrayList<Literal>)hashMap.get(string);
            if (null == arrayList) {
                arrayList = new ArrayList<Literal>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(literal);
        }
        return hashMap;
    }

    private boolean checkSubsumes(Clause clause, Map<String, List<Literal>> map, Map<String, List<Literal>> map2) {
        boolean bl = false;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (String string : map.keySet()) {
            int n = map.get(string).size();
            int n2 = map2.get(string).size();
            if (n2 > 1) {
                for (int i = 0; i < n; ++i) {
                    int n3 = n2 - i;
                    if (n3 <= 1) continue;
                    arrayList3.add(n3);
                }
            }
            for (Literal literal : map.get(string)) {
                arrayList.addAll(literal.getAtomicSentence().getArgs());
            }
        }
        Object object = null;
        long l = 1L;
        if (arrayList3.size() > 0) {
            object = new MixedRadixNumber(0L, arrayList3);
            l = ((MixedRadixNumber)object).getMaxAllowedValue() + 1L;
        }
        Set<Variable> set = _variableCollector.collectAllVariables(clause);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList arrayList4 = new ArrayList();
        for (long i = 0L; i < l; ++i) {
            arrayList2.clear();
            int n = 0;
            for (String string : map.keySet()) {
                int n2 = map.get(string).size();
                arrayList4.clear();
                arrayList4.addAll(map2.get(string));
                int n3 = arrayList4.size();
                if (n3 > 1) {
                    for (int j = 0; j < n2; ++j) {
                        int n4 = n3 - j;
                        if (n4 > 1) {
                            int n5 = ((MixedRadixNumber)object).getCurrentNumeralValue(n);
                            arrayList2.addAll(((Literal)arrayList4.remove(n5)).getAtomicSentence().getArgs());
                            ++n;
                            continue;
                        }
                        arrayList2.addAll(((Literal)arrayList4.get(0)).getAtomicSentence().getArgs());
                    }
                    continue;
                }
                arrayList2.addAll(((Literal)arrayList4.get(0)).getAtomicSentence().getArgs());
            }
            linkedHashMap.clear();
            if (null != _unifier.unify(arrayList, arrayList2, (Map<Variable, Term>)linkedHashMap)) {
                boolean bl2 = false;
                for (Variable variable : linkedHashMap.keySet()) {
                    if (!set.contains(variable)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    bl = true;
                    break;
                }
            }
            if (null == object) continue;
            ((MixedRadixNumber)object).increment();
        }
        return bl;
    }
}

