/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb.data;

import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.kb.data.LiteralsSorter;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClauseEqualityIdentityConstructor
implements FOLVisitor {
    private StringBuilder identity = new StringBuilder();
    private int noVarPositions = 0;
    private int[] clauseVarCounts = null;
    private int currentLiteral = 0;
    private Map<String, List<Integer>> varPositions = new HashMap<String, List<Integer>>();

    public ClauseEqualityIdentityConstructor(List<Literal> list, LiteralsSorter literalsSorter) {
        Serializable serializable;
        List<Integer> list2;
        int n;
        this.clauseVarCounts = new int[list.size()];
        for (Literal literal : list) {
            if (literal.isNegativeLiteral()) {
                this.identity.append("~");
            }
            this.identity.append(literal.getAtomicSentence().getSymbolicName());
            this.identity.append("(");
            n = 1;
            for (Term term : literal.getAtomicSentence().getArgs()) {
                if (n != 0) {
                    n = 0;
                } else {
                    this.identity.append(",");
                }
                term.accept(this, null);
            }
            this.identity.append(")");
            ++this.currentLiteral;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < list.size(); ++n) {
            int n4 = n;
            int n5 = n + 1;
            n2 += this.clauseVarCounts[n];
            while (n5 < list.size() && 0 == literalsSorter.compare(list.get(n), list.get(n5))) {
                n2 += this.clauseVarCounts[n5];
                n4 = n5++;
            }
            if (n5 - n > 1) {
                for (String string2 : this.varPositions.keySet()) {
                    list2 = this.varPositions.get(string2);
                    serializable = new ArrayList();
                    for (int n6 : list2) {
                        if (n6 < n3 || n6 >= n2) continue;
                        int n7 = n6;
                        int n8 = n6;
                        for (int i = n; i < n5 - 1; ++i) {
                            if ((n7 += this.clauseVarCounts[n]) >= n3 && n7 < n2 && !list2.contains(n7) && !serializable.contains(n7)) {
                                serializable.add(n7);
                            }
                            if ((n8 -= this.clauseVarCounts[n]) < n3 || n8 >= n2 || list2.contains(n8) || serializable.contains(n8)) continue;
                            serializable.add(n8);
                        }
                    }
                    list2.addAll((Collection<Integer>)((Object)serializable));
                }
            }
            n3 = n2;
            n = n4;
        }
        n = 1;
        while (this.noVarPositions >= 10) {
            this.noVarPositions /= 10;
            ++n;
        }
        String string = "%0" + n + "d";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.varPositions.keySet()) {
            list2 = this.varPositions.get(string2);
            Collections.sort(list2);
            serializable = new StringBuilder();
            for (int n6 : list2) {
                ((StringBuilder)serializable).append(String.format(string, n6));
            }
            arrayList.add(((StringBuilder)serializable).toString());
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.identity.append((String)arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            this.identity.append(",");
        }
    }

    public String getIdentity() {
        return this.identity.toString();
    }

    @Override
    public Object visitVariable(Variable variable, Object object) {
        this.identity.append("*");
        List<Integer> list = this.varPositions.get(variable.getValue());
        if (null == list) {
            list = new ArrayList<Integer>();
            this.varPositions.put(variable.getValue(), list);
        }
        list.add(this.noVarPositions);
        ++this.noVarPositions;
        int n = this.currentLiteral;
        this.clauseVarCounts[n] = this.clauseVarCounts[n] + 1;
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object object) {
        this.identity.append(constant.getValue());
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object object) {
        boolean bl = true;
        this.identity.append(function.getFunctionName());
        this.identity.append("(");
        for (Term term : function.getTerms()) {
            if (bl) {
                bl = false;
            } else {
                this.identity.append(",");
            }
            term.accept(this, object);
        }
        this.identity.append(")");
        return function;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object object) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitTermEquality(TermEquality termEquality, Object object) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence quantifiedSentence, Object object) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitNotSentence(NotSentence notSentence, Object object) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence connectedSentence, Object object) {
        throw new IllegalStateException("Should not be called");
    }
}

