/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb.data;

import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;

public class Literal {
    private AtomicSentence atom = null;
    private boolean negativeLiteral = false;
    private String strRep = null;
    private int hashCode = 0;

    public Literal(AtomicSentence atomicSentence) {
        this.atom = atomicSentence;
    }

    public Literal(AtomicSentence atomicSentence, boolean bl) {
        this.atom = atomicSentence;
        this.negativeLiteral = bl;
    }

    public Literal newInstance(AtomicSentence atomicSentence) {
        return new Literal(atomicSentence, this.negativeLiteral);
    }

    public boolean isPositiveLiteral() {
        return !this.negativeLiteral;
    }

    public boolean isNegativeLiteral() {
        return this.negativeLiteral;
    }

    public AtomicSentence getAtomicSentence() {
        return this.atom;
    }

    public String toString() {
        if (null == this.strRep) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isNegativeLiteral()) {
                stringBuilder.append("~");
            }
            stringBuilder.append(this.getAtomicSentence().toString());
            this.strRep = stringBuilder.toString();
        }
        return this.strRep;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (!(object instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)object;
        return literal.isPositiveLiteral() == this.isPositiveLiteral() && literal.getAtomicSentence().getSymbolicName().equals(this.atom.getSymbolicName()) && ((Object)literal.getAtomicSentence().getArgs()).equals(this.atom.getArgs());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().getSimpleName().hashCode() + (this.isPositiveLiteral() ? "+".hashCode() : "-".hashCode()) + this.atom.getSymbolicName().hashCode();
            for (Term term : this.atom.getArgs()) {
                this.hashCode = 37 * this.hashCode + term.hashCode();
            }
        }
        return this.hashCode;
    }
}

