/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Predicate
implements AtomicSentence {
    private String predicateName;
    private List<Term> terms = new ArrayList<Term>();
    private String stringRep = null;
    private int hashCode = 0;

    public Predicate(String string, List<Term> list) {
        this.predicateName = string;
        this.terms.addAll(list);
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public String getSymbolicName() {
        return this.getPredicateName();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public List<Term> getArgs() {
        return this.getTerms();
    }

    @Override
    public Object accept(FOLVisitor fOLVisitor, Object object) {
        return fOLVisitor.visitPredicate(this, object);
    }

    @Override
    public Predicate copy() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Term term : this.terms) {
            arrayList.add(term.copy());
        }
        return new Predicate(this.predicateName, arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Predicate)) {
            return false;
        }
        Predicate predicate = (Predicate)object;
        return predicate.getPredicateName().equals(this.getPredicateName()) && ((Object)predicate.getTerms()).equals(this.getTerms());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.predicateName.hashCode();
            for (Term term : this.terms) {
                this.hashCode = 37 * this.hashCode + term.hashCode();
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.predicateName);
            stringBuilder.append("(");
            boolean bl = true;
            for (Term term : this.terms) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(term.toString());
            }
            stringBuilder.append(")");
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }
}

