/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.FOLNode;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QuantifiedSentence
implements Sentence {
    private String quantifier;
    private List<Variable> variables = new ArrayList<Variable>();
    private Sentence quantified;
    private List<FOLNode> args = new ArrayList<FOLNode>();
    private String stringRep = null;
    private int hashCode = 0;

    public QuantifiedSentence(String string, List<Variable> list, Sentence sentence) {
        this.quantifier = string;
        this.variables.addAll(list);
        this.quantified = sentence;
        this.args.addAll(list);
        this.args.add(sentence);
    }

    public String getQuantifier() {
        return this.quantifier;
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public Sentence getQuantified() {
        return this.quantified;
    }

    @Override
    public String getSymbolicName() {
        return this.getQuantifier();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    public List<FOLNode> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public Object accept(FOLVisitor fOLVisitor, Object object) {
        return fOLVisitor.visitQuantifiedSentence(this, object);
    }

    @Override
    public QuantifiedSentence copy() {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (Variable variable : this.variables) {
            arrayList.add(variable.copy());
        }
        return new QuantifiedSentence(this.quantifier, arrayList, this.quantified.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QuantifiedSentence quantifiedSentence = (QuantifiedSentence)object;
        return quantifiedSentence.quantifier.equals(this.quantifier) && ((Object)quantifiedSentence.variables).equals(this.variables) && quantifiedSentence.quantified.equals(this.quantified);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.quantifier.hashCode();
            for (Variable variable : this.variables) {
                this.hashCode = 37 * this.hashCode + variable.hashCode();
            }
            this.hashCode = this.hashCode * 37 + this.quantified.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.quantifier);
            stringBuilder.append(" ");
            for (Variable variable : this.variables) {
                stringBuilder.append(variable.toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.quantified.toString());
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }
}

