/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing.ast;

import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TermEquality
implements AtomicSentence {
    private Term term1;
    private Term term2;
    private List<Term> terms = new ArrayList<Term>();
    private String stringRep = null;
    private int hashCode = 0;

    public static String getEqualitySynbol() {
        return "=";
    }

    public TermEquality(Term term, Term term2) {
        this.term1 = term;
        this.term2 = term2;
        this.terms.add(term);
        this.terms.add(term2);
    }

    public Term getTerm1() {
        return this.term1;
    }

    public Term getTerm2() {
        return this.term2;
    }

    @Override
    public String getSymbolicName() {
        return TermEquality.getEqualitySynbol();
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public List<Term> getArgs() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public Object accept(FOLVisitor fOLVisitor, Object object) {
        return fOLVisitor.visitTermEquality(this, object);
    }

    @Override
    public TermEquality copy() {
        return new TermEquality(this.term1.copy(), this.term2.copy());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TermEquality termEquality = (TermEquality)object;
        return termEquality.getTerm1().equals(this.term1) && termEquality.getTerm2().equals(this.term2);
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getTerm1().hashCode();
            this.hashCode = 37 * this.hashCode + this.getTerm2().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (null == this.stringRep) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.term1.toString());
            stringBuilder.append(" = ");
            stringBuilder.append(this.term2.toString());
            this.stringRep = stringBuilder.toString();
        }
        return this.stringRep;
    }
}

