/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Model
implements PLVisitor {
    Hashtable<String, Boolean> h = new Hashtable();

    public Boolean getStatus(Symbol symbol) {
        Boolean bl = this.h.get(symbol.getValue());
        if (bl != null) {
            return bl;
        }
        return null;
    }

    public boolean isTrue(Symbol symbol) {
        Boolean bl = this.h.get(symbol.getValue());
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isFalse(Symbol symbol) {
        Boolean bl = this.h.get(symbol.getValue());
        if (bl != null) {
            return bl == false;
        }
        return false;
    }

    private boolean isUnknown(Symbol symbol) {
        Boolean bl = this.h.get(symbol.getValue());
        return bl == null;
    }

    public Model extend(Symbol symbol, boolean bl) {
        Model model = new Model();
        return this.extend(symbol.getValue(), bl);
    }

    public Model extend(String string, boolean bl) {
        Model model = new Model();
        for (String string2 : this.h.keySet()) {
            Boolean bl2 = this.h.get(string2);
            String string3 = new String(string2.toCharArray());
            if (bl2 == null) {
                throw new RuntimeException();
            }
            model.h.put(string2, bl2);
        }
        model.h.put(string, new Boolean(bl));
        return model;
    }

    public void print() {
        for (String string : this.h.keySet()) {
            Boolean bl = this.h.get(string);
            System.out.print(string + " = " + bl + " ");
        }
        System.out.println();
    }

    public boolean isTrue(Sentence sentence) {
        Object object = sentence.accept(this, null);
        return object == null ? false : (Boolean)object == true;
    }

    public boolean isFalse(Sentence sentence) {
        Object object = sentence.accept(this, null);
        return object != null ? !((Boolean)object).booleanValue() : false;
    }

    public boolean isUnknown(Sentence sentence) {
        Object object = sentence.accept(this, null);
        return object == null;
    }

    public Model flip(Symbol symbol) {
        if (this.isTrue(symbol)) {
            return this.extend(symbol, false);
        }
        if (this.isFalse(symbol)) {
            return this.extend(symbol, true);
        }
        return this;
    }

    public String toString() {
        return this.h.toString();
    }

    @Override
    public Object visitSymbol(Symbol symbol, Object object) {
        return this.getStatus(symbol);
    }

    @Override
    public Object visitTrueSentence(TrueSentence trueSentence, Object object) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitFalseSentence(FalseSentence falseSentence, Object object) {
        return Boolean.FALSE;
    }

    @Override
    public Object visitNotSentence(UnarySentence unarySentence, Object object) {
        Object object2 = unarySentence.getNegated().accept(this, null);
        if (object2 != null) {
            return new Boolean((Boolean)object2 == false);
        }
        return null;
    }

    @Override
    public Object visitBinarySentence(BinarySentence binarySentence, Object object) {
        Object object2 = binarySentence.getFirst().accept(this, null);
        Object object3 = binarySentence.getSecond().accept(this, null);
        if (object2 == null || object3 == null) {
            return null;
        }
        String string = binarySentence.getOperator();
        if (string.equals("AND")) {
            return this.evaluateAnd((Boolean)object2, (Boolean)object3);
        }
        if (string.equals("OR")) {
            return this.evaluateOr((Boolean)object2, (Boolean)object3);
        }
        if (string.equals("=>")) {
            return this.evaluateImplied((Boolean)object2, (Boolean)object3);
        }
        if (string.equals("<=>")) {
            return this.evaluateBiConditional((Boolean)object2, (Boolean)object3);
        }
        return null;
    }

    @Override
    public Object visitMultiSentence(MultiSentence multiSentence, Object object) {
        return null;
    }

    private Boolean evaluateAnd(Boolean bl, Boolean bl2) {
        if (bl.equals(Boolean.TRUE) && bl2.equals(Boolean.TRUE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean evaluateOr(Boolean bl, Boolean bl2) {
        if (bl.equals(Boolean.TRUE) || bl2.equals(Boolean.TRUE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean evaluateImplied(Boolean bl, Boolean bl2) {
        if (bl.equals(Boolean.TRUE) && bl2.equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean evaluateBiConditional(Boolean bl, Boolean bl2) {
        if (bl.equals(bl2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Set<Symbol> getAssignedSymbols() {
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        Iterator<String> iterator = this.h.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = new Symbol(iterator.next());
            if (this.isUnknown(symbol)) continue;
            hashSet.add(symbol);
        }
        return hashSet;
    }

    public boolean matches(String string, boolean bl) {
        if (bl) {
            return this.isTrue(new Symbol(string));
        }
        if (!bl) {
            return this.isFalse(new Symbol(string));
        }
        return false;
    }
}

