/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.SymbolComparator;
import aima.logic.propositional.parsing.ast.UnarySentence;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolClassifier;
import aima.util.Converter;
import aima.util.LogicUtils;
import aima.util.SetOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PLResolution {
    public boolean plResolution(KnowledgeBase knowledgeBase, String string) {
        return this.plResolution(knowledgeBase, (Sentence)new PEParser().parse(string));
    }

    public boolean plResolution(KnowledgeBase knowledgeBase, Sentence sentence) {
        BinarySentence binarySentence = new BinarySentence("AND", knowledgeBase.asSentence(), new UnarySentence(sentence));
        Set<Sentence> set = new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(binarySentence));
        set = this.filterOutClausesWithTwoComplementaryLiterals(set);
        Set<Object> set2 = new HashSet();
        while (true) {
            List<List<Sentence>> list = this.getCombinationPairs(new Converter<Sentence>().setToList(set));
            for (int i = 0; i < list.size(); ++i) {
                List<Sentence> list2 = list.get(i);
                Set<Sentence> set3 = this.plResolve(list2.get(0), list2.get(1));
                if ((set3 = this.filterOutClausesWithTwoComplementaryLiterals(set3)).contains(new Symbol("EMPTY_CLAUSE"))) {
                    return true;
                }
                set2 = new SetOps<Sentence>().union(set2, set3);
            }
            if (new SetOps<Sentence>().intersection(set2, set).size() == set2.size()) {
                return false;
            }
            set = new SetOps<Sentence>().union(set2, set);
            set = this.filterOutClausesWithTwoComplementaryLiterals(set);
        }
    }

    private Set<Sentence> filterOutClausesWithTwoComplementaryLiterals(Set<Sentence> set) {
        HashSet<Sentence> hashSet = new HashSet<Sentence>();
        SymbolClassifier symbolClassifier = new SymbolClassifier();
        for (Sentence sentence : set) {
            Set<Symbol> set2;
            Set<Symbol> set3 = symbolClassifier.getPositiveSymbolsIn(sentence);
            if (new SetOps<Symbol>().intersection(set3, set2 = symbolClassifier.getNegativeSymbolsIn(sentence)).size() != 0) continue;
            hashSet.add(sentence);
        }
        return hashSet;
    }

    public Set<Sentence> plResolve(Sentence sentence, Sentence sentence2) {
        HashSet<Sentence> hashSet = new HashSet<Sentence>();
        ClauseSymbols clauseSymbols = new ClauseSymbols(sentence, sentence2);
        for (Symbol symbol : clauseSymbols.getComplementedSymbols()) {
            hashSet.add(this.createResolventClause(clauseSymbols, symbol));
        }
        return hashSet;
    }

    private Sentence createResolventClause(ClauseSymbols clauseSymbols, Symbol symbol) {
        int n;
        List<Symbol> list = new Converter<Symbol>().setToList(new SetOps<Symbol>().union(clauseSymbols.clause1PositiveSymbols, clauseSymbols.clause2PositiveSymbols));
        List<Symbol> list2 = new Converter<Symbol>().setToList(new SetOps<Symbol>().union(clauseSymbols.clause1NegativeSymbols, clauseSymbols.clause2NegativeSymbols));
        if (list.contains(symbol)) {
            list.remove(symbol);
        }
        if (list2.contains(symbol)) {
            list2.remove(symbol);
        }
        Collections.sort(list, new SymbolComparator());
        Collections.sort(list2, new SymbolComparator());
        ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(list.get(n));
        }
        for (n = 0; n < list2.size(); ++n) {
            arrayList.add(new UnarySentence(list2.get(n)));
        }
        if (arrayList.size() == 0) {
            return new Symbol("EMPTY_CLAUSE");
        }
        return LogicUtils.chainWith("OR", arrayList);
    }

    private List<List<Sentence>> getCombinationPairs(List<Sentence> list) {
        int n = list.size() % 2;
        int n2 = 0;
        n2 = n == 1 ? list.size() / 2 + 1 : list.size() / 2;
        ArrayList<List<Sentence>> arrayList = new ArrayList<List<Sentence>>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i; j < list.size(); ++j) {
                Sentence sentence;
                ArrayList<Sentence> arrayList2 = new ArrayList<Sentence>();
                Sentence sentence2 = list.get(i);
                if (sentence2.equals(sentence = list.get(j))) continue;
                arrayList2.add(sentence2);
                arrayList2.add(sentence);
                arrayList.add(arrayList2);
            }
        }
        return arrayList;
    }

    public boolean plResolution(String string, String string2) {
        KnowledgeBase knowledgeBase = new KnowledgeBase();
        knowledgeBase.tell(string);
        Sentence sentence = (Sentence)new PEParser().parse(string2);
        return this.plResolution(knowledgeBase, sentence);
    }

    class ClauseSymbols {
        Set<Symbol> clause1Symbols;
        Set<Symbol> clause1PositiveSymbols;
        Set<Symbol> clause1NegativeSymbols;
        Set<Symbol> clause2Symbols;
        Set<Symbol> clause2PositiveSymbols;
        Set<Symbol> clause2NegativeSymbols;
        Set<Symbol> positiveInClause1NegativeInClause2;
        Set<Symbol> negativeInClause1PositiveInClause2;

        public ClauseSymbols(Sentence sentence, Sentence sentence2) {
            SymbolClassifier symbolClassifier = new SymbolClassifier();
            this.clause1Symbols = symbolClassifier.getSymbolsIn(sentence);
            this.clause1PositiveSymbols = symbolClassifier.getPositiveSymbolsIn(sentence);
            this.clause1NegativeSymbols = symbolClassifier.getNegativeSymbolsIn(sentence);
            this.clause2Symbols = symbolClassifier.getSymbolsIn(sentence2);
            this.clause2PositiveSymbols = symbolClassifier.getPositiveSymbolsIn(sentence2);
            this.clause2NegativeSymbols = symbolClassifier.getNegativeSymbolsIn(sentence2);
            this.positiveInClause1NegativeInClause2 = new SetOps<Symbol>().intersection(this.clause1PositiveSymbols, this.clause2NegativeSymbols);
            this.negativeInClause1PositiveInClause2 = new SetOps<Symbol>().intersection(this.clause1NegativeSymbols, this.clause2PositiveSymbols);
        }

        public Set getComplementedSymbols() {
            return new SetOps<Symbol>().union(this.positiveInClause1NegativeInClause2, this.negativeInClause1PositiveInClause2);
        }
    }
}

