/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import aima.util.Util;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WalkSAT {
    private Model myModel;
    private Random random = new Random();

    public Model findModelFor(String string, int n, double d) {
        this.myModel = new Model();
        Sentence sentence = (Sentence)new PEParser().parse(string);
        CNFTransformer cNFTransformer = new CNFTransformer();
        CNFClauseGatherer cNFClauseGatherer = new CNFClauseGatherer();
        SymbolCollector symbolCollector = new SymbolCollector();
        List<Symbol> list = new Converter<Symbol>().setToList(symbolCollector.getSymbolsIn(sentence));
        Random random = new Random();
        for (int i = 0; i < list.size(); ++i) {
            Symbol symbol = list.get(i);
            this.myModel = this.myModel.extend(symbol, Util.randomBoolean());
        }
        List<Sentence> list2 = new Converter<Sentence>().setToList(cNFClauseGatherer.getClausesFrom(cNFTransformer.transform(sentence)));
        for (int i = 0; i < n; ++i) {
            Symbol symbol;
            if (this.getNumberOfClausesSatisfiedIn(new Converter<Sentence>().listToSet(list2), this.myModel) == list2.size()) {
                return this.myModel;
            }
            Sentence sentence2 = list2.get(this.random.nextInt(list2.size()));
            List<Symbol> list3 = new Converter<Symbol>().setToList(symbolCollector.getSymbolsIn(sentence2));
            if (this.random.nextDouble() >= d) {
                symbol = list3.get(this.random.nextInt(list3.size()));
                this.myModel = this.myModel.flip(symbol);
                continue;
            }
            symbol = this.getSymbolWhoseFlipMaximisesSatisfiedClauses(new Converter<Sentence>().listToSet(list2), list3, this.myModel);
            this.myModel = this.myModel.flip(symbol);
        }
        return null;
    }

    private Symbol getSymbolWhoseFlipMaximisesSatisfiedClauses(Set<Sentence> set, List<Symbol> list, Model model) {
        if (list.size() > 0) {
            Symbol symbol = list.get(0);
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                Symbol symbol2 = list.get(i);
                if (this.getNumberOfClausesSatisfiedIn(set, model.flip(symbol2)) <= n) continue;
                symbol = symbol2;
                n = this.getNumberOfClausesSatisfiedIn(set, model.flip(symbol2));
            }
            return symbol;
        }
        return null;
    }

    private int getNumberOfClausesSatisfiedIn(Set set, Model model) {
        int n = 0;
        for (Sentence sentence : set) {
            if (!model.isTrue(sentence)) continue;
            ++n;
        }
        return n;
    }
}

