/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing;

import aima.logic.common.ParseTreeNode;
import aima.logic.common.Parser;
import aima.logic.common.Token;
import aima.logic.propositional.parsing.PELexer;
import aima.logic.propositional.parsing.ast.AtomicSentence;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import java.util.ArrayList;

public class PEParser
extends Parser {
    public PEParser() {
        this.lookAheadBuffer = new Token[this.lookAhead];
    }

    @Override
    public ParseTreeNode parse(String string) {
        this.lexer = new PELexer(string);
        this.fillLookAheadBuffer();
        return this.parseSentence();
    }

    private TrueSentence parseTrue() {
        this.consume();
        return new TrueSentence();
    }

    private FalseSentence parseFalse() {
        this.consume();
        return new FalseSentence();
    }

    private Symbol parseSymbol() {
        String string = this.lookAhead(1).getText();
        this.consume();
        return new Symbol(string);
    }

    private AtomicSentence parseAtomicSentence() {
        Token token = this.lookAhead(1);
        if (token.getType() == 11) {
            return this.parseTrue();
        }
        if (token.getType() == 12) {
            return this.parseFalse();
        }
        if (token.getType() == 1) {
            return this.parseSymbol();
        }
        throw new RuntimeException("Error in parseAtomicSentence with Token " + this.lookAhead(1));
    }

    private UnarySentence parseNotSentence() {
        this.match("NOT");
        Sentence sentence = this.parseSentence();
        return new UnarySentence(sentence);
    }

    private MultiSentence parseMultiSentence() {
        this.consume();
        String string = this.lookAhead(1).getText();
        this.consume();
        ArrayList<Sentence> arrayList = new ArrayList<Sentence>();
        while (this.lookAhead(1).getType() != 3) {
            Sentence sentence = this.parseSentence();
            arrayList.add(sentence);
        }
        this.match(")");
        return new MultiSentence(string, arrayList);
    }

    private Sentence parseSentence() {
        if (this.detectAtomicSentence()) {
            return this.parseAtomicSentence();
        }
        if (this.detectBracket()) {
            return this.parseBracketedSentence();
        }
        if (this.detectNOT()) {
            return this.parseNotSentence();
        }
        throw new RuntimeException("Parser Error Token = " + this.lookAhead(1));
    }

    private boolean detectNOT() {
        return this.lookAhead(1).getType() == 5 && this.lookAhead(1).getText().equals("NOT");
    }

    private Sentence parseBracketedSentence() {
        if (this.detectMultiOperator()) {
            return this.parseMultiSentence();
        }
        this.match("(");
        Sentence sentence = this.parseSentence();
        if (this.lookAhead(1).getType() == 3) {
            this.match(")");
            return sentence;
        }
        if (this.lookAhead(1).getType() == 5 && !this.lookAhead(1).getText().equals("Not")) {
            String string = this.lookAhead(1).getText();
            this.consume();
            Sentence sentence2 = this.parseSentence();
            this.match(")");
            return new BinarySentence(string, sentence, sentence2);
        }
        throw new RuntimeException(" Runtime Exception at Bracketed Expression with token " + this.lookAhead(1));
    }

    private boolean detectMultiOperator() {
        return this.lookAhead(1).getType() == 2 && (this.lookAhead(2).getText().equals("AND") || this.lookAhead(2).getText().equals("OR"));
    }

    private boolean detectBracket() {
        return this.lookAhead(1).getType() == 2;
    }

    private boolean detectAtomicSentence() {
        int n = this.lookAhead(1).getType();
        return n == 11 || n == 12 || n == 1;
    }
}

