/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.parsing.ast;

import aima.logic.propositional.parsing.PLVisitor;
import aima.logic.propositional.parsing.ast.ComplexSentence;
import aima.logic.propositional.parsing.ast.Sentence;

public class BinarySentence
extends ComplexSentence {
    private String operator;
    private Sentence first;
    private Sentence second;

    public BinarySentence(String string, Sentence sentence, Sentence sentence2) {
        this.operator = string;
        this.first = sentence;
        this.second = sentence2;
    }

    public Sentence getFirst() {
        return this.first;
    }

    public String getOperator() {
        return this.operator;
    }

    public Sentence getSecond() {
        return this.second;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BinarySentence binarySentence = (BinarySentence)object;
        return binarySentence.getOperator().equals(this.getOperator()) && binarySentence.getFirst().equals(this.first) && binarySentence.getSecond().equals(this.second);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.first.hashCode();
        n = 37 * n + this.second.hashCode();
        return n;
    }

    public String toString() {
        return " ( " + this.first.toString() + " " + this.operator + " " + this.second.toString() + " )";
    }

    @Override
    public Object accept(PLVisitor pLVisitor, Object object) {
        return pLVisitor.visitBinarySentence(this, object);
    }

    public boolean isOrSentence() {
        return this.getOperator().equals("OR");
    }

    public boolean isAndSentence() {
        return this.getOperator().equals("AND");
    }

    public boolean isImplication() {
        return this.getOperator().equals("=>");
    }

    public boolean isBiconditional() {
        return this.getOperator().equals("<=>");
    }

    public boolean firstTermIsAndSentence() {
        return this.getFirst() instanceof BinarySentence && ((BinarySentence)this.getFirst()).isAndSentence();
    }

    public boolean secondTermIsAndSentence() {
        return this.getSecond() instanceof BinarySentence && ((BinarySentence)this.getSecond()).isAndSentence();
    }
}

