/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.visitors;

import aima.logic.propositional.parsing.AbstractPLVisitor;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.UnarySentence;

public class CNFTransformer
extends AbstractPLVisitor {
    @Override
    public Object visitBinarySentence(BinarySentence binarySentence, Object object) {
        if (binarySentence.isBiconditional()) {
            return this.transformBiConditionalSentence(binarySentence);
        }
        if (binarySentence.isImplication()) {
            return this.transformImpliedSentence(binarySentence);
        }
        if (binarySentence.isOrSentence() && (binarySentence.firstTermIsAndSentence() || binarySentence.secondTermIsAndSentence())) {
            return this.distributeOrOverAnd(binarySentence);
        }
        return super.visitBinarySentence(binarySentence, object);
    }

    @Override
    public Object visitNotSentence(UnarySentence unarySentence, Object object) {
        return this.transformNotSentence(unarySentence);
    }

    public Sentence transform(Sentence sentence) {
        Sentence sentence2 = sentence;
        while (!sentence2.equals(this.step(sentence2))) {
            sentence2 = this.step(sentence2);
        }
        return sentence2;
    }

    private Sentence step(Sentence sentence) {
        return (Sentence)sentence.accept(this, null);
    }

    private Sentence transformBiConditionalSentence(BinarySentence binarySentence) {
        BinarySentence binarySentence2 = new BinarySentence("=>", (Sentence)binarySentence.getFirst().accept(this, null), (Sentence)binarySentence.getSecond().accept(this, null));
        BinarySentence binarySentence3 = new BinarySentence("=>", (Sentence)binarySentence.getSecond().accept(this, null), (Sentence)binarySentence.getFirst().accept(this, null));
        return new BinarySentence("AND", binarySentence2, binarySentence3);
    }

    private Sentence transformImpliedSentence(BinarySentence binarySentence) {
        UnarySentence unarySentence = new UnarySentence((Sentence)binarySentence.getFirst().accept(this, null));
        return new BinarySentence("OR", unarySentence, (Sentence)binarySentence.getSecond().accept(this, null));
    }

    private Sentence transformNotSentence(UnarySentence unarySentence) {
        if (unarySentence.getNegated() instanceof UnarySentence) {
            return (Sentence)((UnarySentence)unarySentence.getNegated()).getNegated().accept(this, null);
        }
        if (unarySentence.getNegated() instanceof BinarySentence) {
            BinarySentence binarySentence = (BinarySentence)unarySentence.getNegated();
            if (binarySentence.isAndSentence()) {
                UnarySentence unarySentence2 = new UnarySentence((Sentence)binarySentence.getFirst().accept(this, null));
                UnarySentence unarySentence3 = new UnarySentence((Sentence)binarySentence.getSecond().accept(this, null));
                return new BinarySentence("OR", unarySentence2, unarySentence3);
            }
            if (binarySentence.isOrSentence()) {
                UnarySentence unarySentence4 = new UnarySentence((Sentence)binarySentence.getFirst().accept(this, null));
                UnarySentence unarySentence5 = new UnarySentence((Sentence)binarySentence.getSecond().accept(this, null));
                return new BinarySentence("AND", unarySentence4, unarySentence5);
            }
            return (Sentence)super.visitNotSentence(unarySentence, null);
        }
        return (Sentence)super.visitNotSentence(unarySentence, null);
    }

    private Sentence distributeOrOverAnd(BinarySentence binarySentence) {
        BinarySentence binarySentence2 = binarySentence.firstTermIsAndSentence() ? (BinarySentence)binarySentence.getFirst() : (BinarySentence)binarySentence.getSecond();
        Sentence sentence = binarySentence.firstTermIsAndSentence() ? binarySentence.getSecond() : binarySentence.getFirst();
        Sentence sentence2 = (Sentence)sentence.accept(this, null);
        Sentence sentence3 = (Sentence)binarySentence2.getFirst().accept(this, null);
        Sentence sentence4 = (Sentence)binarySentence2.getSecond().accept(this, null);
        BinarySentence binarySentence3 = new BinarySentence("AND", new BinarySentence("OR", sentence2, sentence3), new BinarySentence("OR", sentence2, sentence4));
        return binarySentence3;
    }
}

