/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.visitors;

import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.NegativeSymbolCollector;
import aima.logic.propositional.visitors.PositiveSymbolCollector;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.SetOps;
import java.util.Set;

public class SymbolClassifier {
    public Set<Symbol> getPositiveSymbolsIn(Sentence sentence) {
        return new PositiveSymbolCollector().getPositiveSymbolsIn(sentence);
    }

    public Set<Symbol> getNegativeSymbolsIn(Sentence sentence) {
        return new NegativeSymbolCollector().getNegativeSymbolsIn(sentence);
    }

    public Set<Symbol> getPureNegativeSymbolsIn(Sentence sentence) {
        Set<Symbol> set = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().difference(set, set2);
    }

    public Set<Symbol> getPurePositiveSymbolsIn(Sentence sentence) {
        Set<Symbol> set = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().difference(set2, set);
    }

    public Set<Symbol> getPureSymbolsIn(Sentence sentence) {
        Set<Symbol> set = this.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.getPurePositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().union(set2, set);
    }

    public Set<Symbol> getImpureSymbolsIn(Sentence sentence) {
        Set<Symbol> set = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> set2 = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().intersection(set2, set);
    }

    public Set<Symbol> getSymbolsIn(Sentence sentence) {
        return new SymbolCollector().getSymbolsIn(sentence);
    }
}

