/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.BayesNet;
import aima.probability.Query;
import aima.util.Util;
import java.util.Hashtable;
import java.util.List;

public class EnumerationAsk {
    public static double[] ask(Query query, BayesNet bayesNet) {
        String string = query.getQueryVariable();
        Hashtable<String, Boolean> hashtable = query.getEvidenceVariables();
        double[] dArray = new double[2];
        hashtable.put(query.getQueryVariable(), new Boolean(true));
        dArray[0] = EnumerationAsk.enumerateAll(bayesNet, bayesNet.getVariables(), hashtable);
        hashtable.put(query.getQueryVariable(), new Boolean(false));
        dArray[1] = EnumerationAsk.enumerateAll(bayesNet, bayesNet.getVariables(), hashtable);
        double[] dArray2 = Util.normalize(dArray);
        return dArray2;
    }

    private static double enumerateAll(BayesNet bayesNet, List list, Hashtable<String, Boolean> hashtable) {
        if (list.size() == 0) {
            return 1.0;
        }
        String string = (String)list.get(0);
        if (hashtable.keySet().contains(string)) {
            double d = bayesNet.probabilityOf(string, hashtable.get(string), hashtable);
            double d2 = EnumerationAsk.enumerateAll(bayesNet, Util.rest(list), hashtable);
            return d * d2;
        }
        double d = 0.0;
        Hashtable<String, Boolean> hashtable2 = EnumerationAsk.cloneEvidenceVariables(hashtable);
        hashtable2.put(string, Boolean.TRUE);
        double d3 = bayesNet.probabilityOf(string, Boolean.TRUE, hashtable2);
        double d4 = EnumerationAsk.enumerateAll(bayesNet, Util.rest(list), hashtable2);
        double d5 = d3 * d4;
        Hashtable<String, Boolean> hashtable3 = EnumerationAsk.cloneEvidenceVariables(hashtable);
        hashtable3.put(string, Boolean.FALSE);
        double d6 = bayesNet.probabilityOf(string, Boolean.FALSE, hashtable3);
        d4 = EnumerationAsk.enumerateAll(bayesNet, Util.rest(list), hashtable3);
        double d7 = d6 * d4;
        d = d5 + d7;
        return d;
    }

    private static Hashtable<String, Boolean> cloneEvidenceVariables(Hashtable<String, Boolean> hashtable) {
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        for (String string : hashtable.keySet()) {
            Boolean bl = hashtable.get(string);
            if (bl.equals(Boolean.TRUE)) {
                hashtable2.put(string, Boolean.TRUE);
                continue;
            }
            if (!hashtable.get(string).equals(Boolean.FALSE)) continue;
            hashtable2.put(string, Boolean.FALSE);
        }
        return hashtable2;
    }
}

