/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.logic.propositional.algorithms.Model;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ProbabilityDistribution {
    private List<Row> rows;
    String[] variableNames;

    public ProbabilityDistribution(String string) {
        this(new String[]{string});
    }

    public ProbabilityDistribution(String string, String string2) {
        this(new String[]{string, string2});
    }

    public ProbabilityDistribution(String string, String string2, String string3) {
        this(new String[]{string, string2, string3});
    }

    public ProbabilityDistribution(String string, String string2, String string3, String string4) {
        this(new String[]{string, string2, string3, string4});
    }

    public ProbabilityDistribution(String[] stringArray) {
        this.variableNames = stringArray;
        this.rows = new ArrayList<Row>();
    }

    public void set(boolean[] blArray, double d) {
        Model model = new Model();
        for (int i = 0; i < this.variableNames.length; ++i) {
            model = model.extend(this.variableNames[i], blArray[i]);
        }
        this.rows.add(new Row(model, d));
    }

    public void set(boolean bl, double d) {
        this.set(new boolean[]{bl}, d);
    }

    public void set(boolean bl, boolean bl2, double d) {
        this.set(new boolean[]{bl, bl2}, d);
    }

    public void set(boolean bl, boolean bl2, boolean bl3, double d) {
        this.set(new boolean[]{bl, bl2, bl3}, d);
    }

    public void set(boolean bl, boolean bl2, boolean bl3, boolean bl4, double d) {
        this.set(new boolean[]{bl, bl2, bl3, bl4}, d);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Row row : this.rows) {
            stringBuffer.append(row.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public double probabilityOf(Hashtable hashtable) {
        double d = 0.0;
        for (Row row : this.rows) {
            Iterator iterator = hashtable.keySet().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                boolean bl2;
                String string = (String)iterator.next();
                if (row.model.matches(string, bl2 = ((Boolean)hashtable.get(string)).booleanValue())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            d += row.probability;
        }
        return d;
    }

    public double probabilityOf(String string, boolean bl) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put(string, new Boolean(bl));
        return this.probabilityOf(hashtable);
    }

    class Row {
        Model model;
        double probability;

        Row(Model model, double d) {
            this.model = model;
            this.probability = d;
        }

        public String toString() {
            return this.model.toString() + " => " + this.probability;
        }
    }
}

