/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.decision.cellworld;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPPerception;
import aima.probability.decision.MDPRewardFunction;
import aima.probability.decision.MDPSource;
import aima.probability.decision.MDPTransitionModel;
import aima.probability.decision.cellworld.Cell;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class CellWorld
implements MDPSource<CellWorldPosition, String> {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String NO_OP = "no_op";
    List<Cell> blockedCells;
    List<Cell> allCells = new ArrayList<Cell>();
    private int numberOfRows;
    private int numberOfColumns;
    private List<Cell> terminalStates;
    private Cell initialState;

    public CellWorld(int n, int n2, double d) {
        this.blockedCells = new ArrayList<Cell>();
        this.terminalStates = new ArrayList<Cell>();
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                this.allCells.add(new Cell(i, j, d));
            }
        }
        this.initialState = this.getCellAt(1, 4);
    }

    public void markBlocked(int n, int n2) {
        this.blockedCells.add(this.getCellAt(n, n2));
    }

    private boolean isBlocked(int n, int n2) {
        if (n < 1 || n > this.numberOfRows || n2 < 1 || n2 > this.numberOfColumns) {
            return true;
        }
        for (Cell cell : this.blockedCells) {
            if (cell.getX() != n || cell.getY() != n2) continue;
            return true;
        }
        return false;
    }

    private Cell getCellAt(int n, int n2) {
        for (Cell cell : this.allCells) {
            if (cell.getX() != n || cell.getY() != n2) continue;
            return cell;
        }
        throw new RuntimeException("No Cell found at " + n + " , " + n2);
    }

    public CellWorldPosition moveProbabilisticallyFrom(int n, int n2, String string, Randomizer randomizer) {
        Cell cell = this.getCellAt(n, n2);
        if (this.terminalStates.contains(cell)) {
            return cell.position();
        }
        return this.moveFrom(n, n2, this.determineDirectionOfActualMovement(string, randomizer));
    }

    private CellWorldPosition moveFrom(int n, int n2, String string) {
        if (string.equals(LEFT)) {
            return this.moveLeftFrom(n, n2);
        }
        if (string.equals(RIGHT)) {
            return this.moveRightFrom(n, n2);
        }
        if (string.equals(UP)) {
            return this.moveUpFrom(n, n2);
        }
        if (string.equals(DOWN)) {
            return this.moveDownFrom(n, n2);
        }
        throw new RuntimeException("Unable to move " + string + " from " + n + " , " + n2);
    }

    private CellWorldPosition moveFrom(CellWorldPosition cellWorldPosition, String string) {
        return this.moveFrom(cellWorldPosition.getX(), cellWorldPosition.getY(), string);
    }

    private String determineDirectionOfActualMovement(String string, double d) {
        if (d < 0.8) {
            return string;
        }
        if (d > 0.8 && d < 0.9) {
            if (string.equals(LEFT) || string.equals(RIGHT)) {
                return UP;
            }
            if (string.equals(UP) || string.equals(DOWN)) {
                return LEFT;
            }
        } else {
            if (string.equals(LEFT) || string.equals(RIGHT)) {
                return DOWN;
            }
            if (string.equals(UP) || string.equals(DOWN)) {
                return RIGHT;
            }
        }
        throw new RuntimeException("Unable to determine direction when command =  " + string + " and probability = " + d);
    }

    private String determineDirectionOfActualMovement(String string, Randomizer randomizer) {
        return this.determineDirectionOfActualMovement(string, randomizer.nextDouble());
    }

    private CellWorldPosition moveLeftFrom(int n, int n2) {
        if (this.isBlocked(n, n2 - 1)) {
            return new CellWorldPosition(n, n2);
        }
        return new CellWorldPosition(n, n2 - 1);
    }

    private CellWorldPosition moveRightFrom(int n, int n2) {
        if (this.isBlocked(n, n2 + 1)) {
            return new CellWorldPosition(n, n2);
        }
        return new CellWorldPosition(n, n2 + 1);
    }

    private CellWorldPosition moveUpFrom(int n, int n2) {
        if (this.isBlocked(n + 1, n2)) {
            return new CellWorldPosition(n, n2);
        }
        return new CellWorldPosition(n + 1, n2);
    }

    private CellWorldPosition moveDownFrom(int n, int n2) {
        if (this.isBlocked(n - 1, n2)) {
            return new CellWorldPosition(n, n2);
        }
        return new CellWorldPosition(n - 1, n2);
    }

    public void setReward(int n, int n2, double d) {
        Cell cell = this.getCellAt(n, n2);
        cell.setReward(d);
    }

    public List<Cell> unblockedCells() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        for (Cell cell : this.allCells) {
            if (this.blockedCells.contains(cell)) continue;
            arrayList.add(cell);
        }
        return arrayList;
    }

    public boolean isBlocked(Pair<Integer, Integer> pair) {
        return this.isBlocked(pair.getFirst(), pair.getSecond());
    }

    public double getTransitionProbability(CellWorldPosition cellWorldPosition, String string, CellWorldPosition cellWorldPosition2) {
        String string2 = this.determineDirectionOfActualMovement(string, 0.85);
        String string3 = this.determineDirectionOfActualMovement(string, 0.95);
        Hashtable<String, CellWorldPosition> hashtable = new Hashtable<String, CellWorldPosition>();
        hashtable.put(string, this.moveFrom(cellWorldPosition, string));
        hashtable.put(string2, this.moveFrom(cellWorldPosition, string2));
        hashtable.put(string3, this.moveFrom(cellWorldPosition, string3));
        Hashtable<CellWorldPosition, Double> hashtable2 = new Hashtable<CellWorldPosition, Double>();
        for (Object object : hashtable.values()) {
            hashtable2.put((CellWorldPosition)object, 0.0);
        }
        for (Object object : hashtable.keySet()) {
            CellWorldPosition cellWorldPosition3 = (CellWorldPosition)hashtable.get(object);
            double d = (Double)hashtable2.get(cellWorldPosition3);
            if (((String)object).equals(string)) {
                hashtable2.put(cellWorldPosition3, d + 0.8);
                continue;
            }
            hashtable2.put(cellWorldPosition3, d + 0.1);
        }
        if (hashtable2.keySet().contains(cellWorldPosition2)) {
            return (Double)hashtable2.get(cellWorldPosition2);
        }
        return 0.0;
    }

    @Override
    public MDPTransitionModel<CellWorldPosition, String> getTransitionModel() {
        ArrayList<CellWorldPosition> arrayList = new ArrayList<CellWorldPosition>();
        for (Cell object2 : this.terminalStates) {
            arrayList.add(object2.position());
        }
        MDPTransitionModel mDPTransitionModel = new MDPTransitionModel(arrayList);
        List<String> list = Arrays.asList(UP, DOWN, LEFT, RIGHT);
        for (CellWorldPosition cellWorldPosition : this.getNonFinalStates()) {
            for (String string : list) {
                for (Cell cell : this.unblockedCells()) {
                    CellWorldPosition cellWorldPosition2 = cell.position();
                    double d = this.getTransitionProbability(cellWorldPosition, string, cellWorldPosition2);
                    if (d == 0.0) continue;
                    mDPTransitionModel.setTransitionProbability(cellWorldPosition, string, cellWorldPosition2, d);
                }
            }
        }
        return mDPTransitionModel;
    }

    @Override
    public MDPRewardFunction<CellWorldPosition> getRewardFunction() {
        MDPRewardFunction<CellWorldPosition> mDPRewardFunction = new MDPRewardFunction<CellWorldPosition>();
        for (Cell cell : this.unblockedCells()) {
            CellWorldPosition cellWorldPosition = cell.position();
            double d = cell.getReward();
            mDPRewardFunction.setReward(cellWorldPosition, d);
        }
        return mDPRewardFunction;
    }

    public List<CellWorldPosition> unblockedPositions() {
        ArrayList<CellWorldPosition> arrayList = new ArrayList<CellWorldPosition>();
        for (Cell cell : this.unblockedCells()) {
            arrayList.add(cell.position());
        }
        return arrayList;
    }

    @Override
    public MDP<CellWorldPosition, String> asMdp() {
        return new MDP<CellWorldPosition, String>(this);
    }

    @Override
    public List<CellWorldPosition> getNonFinalStates() {
        List<CellWorldPosition> list = this.unblockedPositions();
        list.remove(this.getCellAt(2, 4).position());
        list.remove(this.getCellAt(3, 4).position());
        return list;
    }

    @Override
    public List<CellWorldPosition> getFinalStates() {
        ArrayList<CellWorldPosition> arrayList = new ArrayList<CellWorldPosition>();
        arrayList.add(this.getCellAt(2, 4).position());
        arrayList.add(this.getCellAt(3, 4).position());
        return arrayList;
    }

    public void setTerminalState(int n, int n2) {
        this.setTerminalState(new CellWorldPosition(n, n2));
    }

    public void setTerminalState(CellWorldPosition cellWorldPosition) {
        this.terminalStates.add(this.getCellAt(cellWorldPosition.getX(), cellWorldPosition.getY()));
    }

    @Override
    public CellWorldPosition getInitialState() {
        return this.initialState.position();
    }

    @Override
    public MDPPerception<CellWorldPosition> execute(CellWorldPosition cellWorldPosition, String string, Randomizer randomizer) {
        CellWorldPosition cellWorldPosition2 = this.moveProbabilisticallyFrom(cellWorldPosition.getX(), cellWorldPosition.getY(), string, randomizer);
        double d = this.getCellAt(cellWorldPosition2.getX(), cellWorldPosition2.getY()).getReward();
        return new MDPPerception<CellWorldPosition>(cellWorldPosition2, d);
    }

    @Override
    public List<String> getAllActions() {
        return Arrays.asList(LEFT, RIGHT, UP, DOWN);
    }
}

