/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.demos;

import aima.learning.reinforcement.PassiveADPAgent;
import aima.learning.reinforcement.PassiveTDAgent;
import aima.learning.reinforcement.QLearningAgent;
import aima.learning.reinforcement.QTable;
import aima.probability.BayesNet;
import aima.probability.BayesNetNode;
import aima.probability.EnumerateJointAsk;
import aima.probability.EnumerationAsk;
import aima.probability.JavaRandomizer;
import aima.probability.ProbabilityDistribution;
import aima.probability.Query;
import aima.probability.RandomVariable;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPFactory;
import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.probability.reasoning.HMMFactory;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.ParticleSet;
import aima.util.Pair;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ProbabilityDemo {
    public static void main(String[] stringArray) {
        ProbabilityDemo.enumerationJointAskDemo();
        ProbabilityDemo.enumerationAskDemo();
        ProbabilityDemo.priorSampleDemo();
        ProbabilityDemo.rejectionSamplingDemo();
        ProbabilityDemo.likelihoodWeightingDemo();
        ProbabilityDemo.mcmcAskDemo();
        ProbabilityDemo.forwardBackWardDemo();
        ProbabilityDemo.particleFilterinfDemo();
        ProbabilityDemo.valueIterationDemo();
        ProbabilityDemo.policyIterationDemo();
        ProbabilityDemo.passiveADPgentDemo();
        ProbabilityDemo.passiveTDAgentDemo();
        ProbabilityDemo.qLearningAgentDemo();
    }

    private static void forwardBackWardDemo() {
        System.out.println("\nForward BackWard Demo\n");
        HiddenMarkovModel hiddenMarkovModel = HMMFactory.createRainmanHMM();
        System.out.println("Creating a Hdden Markov Model to represent the model in Fig 15.5 ");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("carries_umbrella");
        arrayList.add("carries_umbrella");
        List<RandomVariable> list = hiddenMarkovModel.forward_backward(arrayList);
        RandomVariable randomVariable = list.get(1);
        System.out.println("Smoothed Probability Of Raining on Day One = " + randomVariable.getProbabilityOf("rain"));
        System.out.println("Smoothed Probability Of NOT Raining on Day One =" + randomVariable.getProbabilityOf("no_rain"));
        RandomVariable randomVariable2 = list.get(2);
        System.out.println("Smoothed Probability Of Raining on Day Two = " + randomVariable2.getProbabilityOf("rain"));
        System.out.println("Smoothed Probability Of NOT Raining on Day Two = " + randomVariable2.getProbabilityOf("no_rain"));
    }

    private static void particleFilterinfDemo() {
        System.out.println("\nParticle Filtering Demo\n");
        HiddenMarkovModel hiddenMarkovModel = HMMFactory.createRainmanHMM();
        JavaRandomizer javaRandomizer = new JavaRandomizer();
        ParticleSet particleSet = hiddenMarkovModel.prior().toParticleSet(hiddenMarkovModel, javaRandomizer, 1000);
        System.out.println("at the beginning, " + particleSet.numberOfParticlesWithState("rain") + " particles 0f 1000 indicate status == 'raining' ");
        System.out.println("at the beginning, " + particleSet.numberOfParticlesWithState("no_rain") + " particles of 1000 indicate status == 'NOT raining' ");
        System.out.println("\n Filtering Particle Set.On perception == 'SEE_UMBRELLA' ..\n");
        ParticleSet particleSet2 = particleSet.filter("carries_umbrella", javaRandomizer);
        System.out.println("after filtering " + particleSet2.numberOfParticlesWithState("rain") + " particles of 1000 indicate status == 'raining' ");
        System.out.println("after filtering " + particleSet2.numberOfParticlesWithState("no_rain") + " particles of 1000 indicate status == 'NOT raining' ");
    }

    private static void valueIterationDemo() {
        System.out.println("\nValue Iteration Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> mDP = MDPFactory.createFourByThreeMDP();
        System.out.println("Beginning Value Iteration");
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction = mDP.valueIterationTillMAximumUtilityGrowthFallsBelowErrorMargin(1.0, 1.0E-5);
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printUtility(mDPUtilityFunction, i, j);
            }
        }
    }

    private static void printUtility(MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction, int n, int n2) {
        System.out.println("Utility of (" + n + " , " + n2 + " ) " + mDPUtilityFunction.getUtility(new CellWorldPosition(n, n2)));
    }

    private static void policyIterationDemo() {
        System.out.println("\nPolicy Iteration Demo\n");
        System.out.println("\nValue Iteration Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> mDP = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> mDPPolicy = mDP.policyIteration(1.0);
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (i == 2 && j == 2) continue;
                ProbabilityDemo.printPolicy(i, j, mDPPolicy);
            }
        }
    }

    private static void printPolicy(int n, int n2, MDPPolicy<CellWorldPosition, String> mDPPolicy) {
        System.out.println("Reccomended Action for (" + n + " , " + n2 + " )  =  " + mDPPolicy.getAction(new CellWorldPosition(n, n2)));
    }

    private static void passiveADPgentDemo() {
        int n;
        System.out.println("\nPassive ADP Agent Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> mDP = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> mDPPolicy = new MDPPolicy<CellWorldPosition, String>();
        System.out.println("Creating a policy to reflect the policy in Fig 17.3");
        mDPPolicy.setAction(new CellWorldPosition(1, 1), "up");
        mDPPolicy.setAction(new CellWorldPosition(1, 2), "left");
        mDPPolicy.setAction(new CellWorldPosition(1, 3), "left");
        mDPPolicy.setAction(new CellWorldPosition(1, 4), "left");
        mDPPolicy.setAction(new CellWorldPosition(2, 1), "up");
        mDPPolicy.setAction(new CellWorldPosition(2, 3), "up");
        mDPPolicy.setAction(new CellWorldPosition(3, 1), "right");
        mDPPolicy.setAction(new CellWorldPosition(3, 2), "right");
        mDPPolicy.setAction(new CellWorldPosition(3, 3), "right");
        PassiveADPAgent<CellWorldPosition, String> passiveADPAgent = new PassiveADPAgent<CellWorldPosition, String>(mDP, mDPPolicy);
        JavaRandomizer javaRandomizer = new JavaRandomizer();
        System.out.println("Deriving Utility Function using the Passive ADP Agent  From 100 trials in the 4 by 3 world");
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction = null;
        for (n = 0; n < 100; ++n) {
            passiveADPAgent.executeTrial(javaRandomizer);
            mDPUtilityFunction = passiveADPAgent.getUtilityFunction();
        }
        for (n = 1; n <= 3; ++n) {
            for (int i = 1; i <= 4; ++i) {
                if (n == 2 && i == 2) continue;
                ProbabilityDemo.printUtility(mDPUtilityFunction, n, i);
            }
        }
    }

    private static void passiveTDAgentDemo() {
        int n;
        System.out.println("\nPassive TD Agent Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> mDP = MDPFactory.createFourByThreeMDP();
        MDPPolicy<CellWorldPosition, String> mDPPolicy = new MDPPolicy<CellWorldPosition, String>();
        System.out.println("Creating a policy to reflect the policy in Fig 17.3");
        mDPPolicy.setAction(new CellWorldPosition(1, 1), "up");
        mDPPolicy.setAction(new CellWorldPosition(1, 2), "left");
        mDPPolicy.setAction(new CellWorldPosition(1, 3), "left");
        mDPPolicy.setAction(new CellWorldPosition(1, 4), "left");
        mDPPolicy.setAction(new CellWorldPosition(2, 1), "up");
        mDPPolicy.setAction(new CellWorldPosition(2, 3), "up");
        mDPPolicy.setAction(new CellWorldPosition(3, 1), "right");
        mDPPolicy.setAction(new CellWorldPosition(3, 2), "right");
        mDPPolicy.setAction(new CellWorldPosition(3, 3), "right");
        PassiveTDAgent<CellWorldPosition, String> passiveTDAgent = new PassiveTDAgent<CellWorldPosition, String>(mDP, mDPPolicy);
        JavaRandomizer javaRandomizer = new JavaRandomizer();
        System.out.println("Deriving Utility Function in the Passive ADP Agent  From 200 trials in the 4 by 3 world");
        MDPUtilityFunction<CellWorldPosition> mDPUtilityFunction = null;
        for (n = 0; n < 200; ++n) {
            passiveTDAgent.executeTrial(javaRandomizer);
            mDPUtilityFunction = passiveTDAgent.getUtilityFunction();
        }
        for (n = 1; n <= 3; ++n) {
            for (int i = 1; i <= 4; ++i) {
                if (n == 2 && i == 2) continue;
                ProbabilityDemo.printUtility(mDPUtilityFunction, n, i);
            }
        }
    }

    private static void qLearningAgentDemo() {
        System.out.println("\nQ Learning Agent Demo Demo\n");
        System.out.println("creating an MDP to represent the 4 X 3 world");
        MDP<CellWorldPosition, String> mDP = MDPFactory.createFourByThreeMDP();
        QLearningAgent<CellWorldPosition, String> qLearningAgent = new QLearningAgent<CellWorldPosition, String>(mDP);
        JavaRandomizer javaRandomizer = new JavaRandomizer();
        Hashtable<Pair<CellWorldPosition, String>, Double> hashtable = null;
        QTable<CellWorldPosition, String> qTable = null;
        System.out.println("After 100 trials in the 4 by 3 world");
        for (int i = 0; i < 100; ++i) {
            qLearningAgent.executeTrial(javaRandomizer);
            hashtable = qLearningAgent.getQ();
            qTable = qLearningAgent.getQTable();
        }
        System.out.println("Final Q table" + qTable);
    }

    public static void enumerationJointAskDemo() {
        System.out.println("\nEnumerationJointAsk Demo\n");
        ProbabilityDistribution probabilityDistribution = new ProbabilityDistribution("ToothAche", "Cavity", "Catch");
        probabilityDistribution.set(true, true, true, 0.108);
        probabilityDistribution.set(true, true, false, 0.012);
        probabilityDistribution.set(false, true, true, 0.072);
        probabilityDistribution.set(false, true, false, 0.008);
        probabilityDistribution.set(true, false, true, 0.016);
        probabilityDistribution.set(true, false, false, 0.064);
        probabilityDistribution.set(false, false, true, 0.144);
        probabilityDistribution.set(false, false, false, 0.008);
        Query query = new Query("Cavity", new String[]{"ToothAche"}, new boolean[]{true});
        double[] dArray = EnumerateJointAsk.ask(query, probabilityDistribution);
        System.out.println("Using the full joint distribution of page 475 of Aima 2nd Edition");
        System.out.println("Probability distribution of ToothAche using Enumeration joint ask is " + ProbabilityDemo.string(dArray));
    }

    private static void priorSampleDemo() {
        System.out.println("\nPriorSample Demo\n");
        BayesNet bayesNet = ProbabilityDemo.createWetGrassNetwork();
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition generates");
        Hashtable hashtable = bayesNet.getPriorSample();
        System.out.println(hashtable.toString());
    }

    private static void rejectionSamplingDemo() {
        BayesNet bayesNet = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.rejectionSample("Rain", hashtable, 100);
        System.out.println("\nRejectionSampling Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(dArray));
    }

    private static void likelihoodWeightingDemo() {
        BayesNet bayesNet = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.likelihoodWeighting("Rain", hashtable, 100);
        System.out.println("\nLikelihoodWeighting Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(dArray));
    }

    private static void mcmcAskDemo() {
        BayesNet bayesNet = ProbabilityDemo.createWetGrassNetwork();
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put("Sprinkler", Boolean.TRUE);
        double[] dArray = bayesNet.mcmcAsk("Rain", hashtable, 100);
        System.out.println("\nMCMCAsk Demo\n");
        System.out.println("Using the Bayesian Network from page 510 of AIMA 2nd Edition ");
        System.out.println("and querying for P(Rain|Sprinkler=true) using 100 samples gives");
        System.out.println(ProbabilityDemo.string(dArray));
    }

    public static void enumerationAskDemo() {
        System.out.println("\nEnumerationAsk Demo\n");
        Query query = new Query("Burglary", new String[]{"JohnCalls", "MaryCalls"}, new boolean[]{true, true});
        double[] dArray = EnumerationAsk.ask(query, ProbabilityDemo.createBurglaryNetwork());
        System.out.println("Using the Burglary BayesNet from page 494 of AIMA 2nd Edition");
        System.out.println("Querying the probability of Burglary|JohnCalls=true, MaryCalls=true gives " + ProbabilityDemo.string(dArray));
    }

    private static BayesNet createBurglaryNetwork() {
        BayesNetNode bayesNetNode = new BayesNetNode("Burglary");
        BayesNetNode bayesNetNode2 = new BayesNetNode("EarthQuake");
        BayesNetNode bayesNetNode3 = new BayesNetNode("Alarm");
        BayesNetNode bayesNetNode4 = new BayesNetNode("JohnCalls");
        BayesNetNode bayesNetNode5 = new BayesNetNode("MaryCalls");
        bayesNetNode3.influencedBy(bayesNetNode, bayesNetNode2);
        bayesNetNode4.influencedBy(bayesNetNode3);
        bayesNetNode5.influencedBy(bayesNetNode3);
        bayesNetNode.setProbability(true, 0.001);
        bayesNetNode2.setProbability(true, 0.002);
        bayesNetNode3.setProbability(true, true, 0.95);
        bayesNetNode3.setProbability(true, false, 0.94);
        bayesNetNode3.setProbability(false, true, 0.29);
        bayesNetNode3.setProbability(false, false, 0.001);
        bayesNetNode4.setProbability(true, 0.9);
        bayesNetNode4.setProbability(false, 0.05);
        bayesNetNode5.setProbability(true, 0.7);
        bayesNetNode5.setProbability(false, 0.01);
        BayesNet bayesNet = new BayesNet(bayesNetNode, bayesNetNode2);
        return bayesNet;
    }

    private static BayesNet createWetGrassNetwork() {
        BayesNetNode bayesNetNode = new BayesNetNode("Cloudy");
        BayesNetNode bayesNetNode2 = new BayesNetNode("Sprinkler");
        BayesNetNode bayesNetNode3 = new BayesNetNode("Rain");
        BayesNetNode bayesNetNode4 = new BayesNetNode("WetGrass");
        bayesNetNode2.influencedBy(bayesNetNode);
        bayesNetNode3.influencedBy(bayesNetNode);
        bayesNetNode4.influencedBy(bayesNetNode3, bayesNetNode2);
        bayesNetNode.setProbability(true, 0.5);
        bayesNetNode2.setProbability(true, 0.1);
        bayesNetNode2.setProbability(false, 0.5);
        bayesNetNode3.setProbability(true, 0.8);
        bayesNetNode3.setProbability(false, 0.2);
        bayesNetNode4.setProbability(true, true, 0.99);
        bayesNetNode4.setProbability(true, false, 0.9);
        bayesNetNode4.setProbability(false, true, 0.9);
        bayesNetNode4.setProbability(false, false, 0.0);
        BayesNet bayesNet = new BayesNet(bayesNetNode);
        return bayesNet;
    }

    private static String string(double[] dArray) {
        return " [ " + dArray[0] + " , " + dArray[1] + " ] ";
    }
}

