/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.util.Matrix;
import java.util.ArrayList;

public class FixedLagSmoothing {
    private HiddenMarkovModel hmm;
    private int timelag;
    private ArrayList<String> evidenceFromSmoothedStepToPresent;
    private int time;
    private RandomVariable forwardMessage;
    private Matrix B;

    public FixedLagSmoothing(HiddenMarkovModel hiddenMarkovModel, int n) {
        this.hmm = hiddenMarkovModel;
        this.timelag = n;
        this.evidenceFromSmoothedStepToPresent = new ArrayList();
        this.time = 1;
        this.forwardMessage = hiddenMarkovModel.prior();
        this.B = hiddenMarkovModel.transitionModel().unitMatrix();
    }

    public RandomVariable smooth(String string) {
        Matrix matrix;
        this.evidenceFromSmoothedStepToPresent.add(string);
        Matrix matrix2 = this.hmm.sensorModel().asMatrix(string);
        Matrix matrix3 = this.hmm.transitionModel().asMatrix();
        if (this.time > this.timelag) {
            this.forwardMessage = this.hmm.forward(this.forwardMessage, string);
            this.evidenceFromSmoothedStepToPresent.remove(0);
            matrix = this.hmm.sensorModel().asMatrix(this.evidenceFromSmoothedStepToPresent.get(0));
            this.B = matrix.inverse().times(matrix3.inverse().times(this.B.times(matrix3.times(matrix2))));
        } else {
            this.B = this.B.times(matrix3.times(matrix2));
        }
        ++this.time;
        if (this.time > this.timelag) {
            matrix = this.hmm.prior().createUnitBelief().asMatrix();
            Matrix matrix4 = this.forwardMessage.asMatrix();
            RandomVariable randomVariable = this.hmm.prior().duplicate();
            Matrix matrix5 = this.B.times(matrix);
            randomVariable.updateFrom(matrix4.arrayTimes(matrix5));
            randomVariable.normalize();
            return randomVariable;
        }
        return null;
    }
}

