/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.SensorModel;
import aima.probability.reasoning.TransitionModel;
import java.util.Arrays;
import java.util.List;

public class HMMFactory {
    public static HiddenMarkovModel createRobotHMM() {
        List<String> list = Arrays.asList("open", "closed");
        List<String> list2 = Arrays.asList("do_nothing", "push");
        List<String> list3 = Arrays.asList("see_open", "see_closed");
        RandomVariable randomVariable = new RandomVariable(list);
        TransitionModel transitionModel = new TransitionModel(list, list2);
        transitionModel.setTransitionProbability("open", "do_nothing", "open", 1.0);
        transitionModel.setTransitionProbability("open", "do_nothing", "open", 1.0);
        transitionModel.setTransitionProbability("open", "do_nothing", "closed", 0.0);
        transitionModel.setTransitionProbability("closed", "do_nothing", "closed", 1.0);
        transitionModel.setTransitionProbability("closed", "do_nothing", "open", 0.0);
        transitionModel.setTransitionProbability("open", "push", "open", 1.0);
        transitionModel.setTransitionProbability("open", "push", "closed", 0.0);
        transitionModel.setTransitionProbability("closed", "push", "closed", 0.2);
        transitionModel.setTransitionProbability("closed", "push", "open", 0.8);
        SensorModel sensorModel = new SensorModel(list, list3);
        sensorModel.setSensingProbability("open", "see_closed", 0.4);
        sensorModel.setSensingProbability("open", "see_open", 0.6);
        sensorModel.setSensingProbability("closed", "see_open", 0.2);
        sensorModel.setSensingProbability("closed", "see_closed", 0.8);
        HiddenMarkovModel hiddenMarkovModel = new HiddenMarkovModel(randomVariable, transitionModel, sensorModel);
        return hiddenMarkovModel;
    }

    public static HiddenMarkovModel createRainmanHMM() {
        List<String> list = Arrays.asList("rain", "no_rain");
        List<String> list2 = Arrays.asList("carries_umbrella", "does_not_carry_umbrella");
        RandomVariable randomVariable = new RandomVariable(list);
        TransitionModel transitionModel = new TransitionModel(list);
        transitionModel.setTransitionProbability("rain", "rain", 0.7);
        transitionModel.setTransitionProbability("rain", "no_rain", 0.3);
        transitionModel.setTransitionProbability("no_rain", "rain", 0.3);
        transitionModel.setTransitionProbability("no_rain", "no_rain", 0.7);
        SensorModel sensorModel = new SensorModel(list, list2);
        sensorModel.setSensingProbability("rain", "carries_umbrella", 0.9);
        sensorModel.setSensingProbability("rain", "does_not_carry_umbrella", 0.1);
        sensorModel.setSensingProbability("no_rain", "carries_umbrella", 0.2);
        sensorModel.setSensingProbability("no_rain", "does_not_carry_umbrella", 0.8);
        HiddenMarkovModel hiddenMarkovModel = new HiddenMarkovModel(randomVariable, transitionModel, sensorModel);
        return hiddenMarkovModel;
    }
}

