/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.SensorModel;
import aima.probability.reasoning.TransitionModel;
import aima.util.Matrix;
import java.util.Arrays;
import java.util.List;

public class HiddenMarkovModel {
    SensorModel sensorModel;
    TransitionModel transitionModel;
    private RandomVariable priorDistribution;

    public HiddenMarkovModel(RandomVariable randomVariable, TransitionModel transitionModel, SensorModel sensorModel) {
        this.priorDistribution = randomVariable;
        this.transitionModel = transitionModel;
        this.sensorModel = sensorModel;
    }

    public RandomVariable prior() {
        return this.priorDistribution;
    }

    public RandomVariable predict(RandomVariable randomVariable, String string) {
        RandomVariable randomVariable2 = randomVariable.duplicate();
        Matrix matrix = randomVariable.asMatrix();
        Matrix matrix2 = this.transitionModel.asMatrix(string);
        Matrix matrix3 = matrix2.transpose().times(matrix);
        randomVariable2.updateFrom(matrix3);
        return randomVariable2;
    }

    public RandomVariable perceptionUpdate(RandomVariable randomVariable, String string) {
        RandomVariable randomVariable2 = randomVariable.duplicate();
        Matrix matrix = randomVariable.asMatrix();
        Matrix matrix2 = this.sensorModel.asMatrix(string);
        Matrix matrix3 = matrix2.times(matrix);
        randomVariable2.updateFrom(matrix3);
        randomVariable2.normalize();
        return randomVariable2;
    }

    public RandomVariable forward(RandomVariable randomVariable, String string, String string2) {
        return this.perceptionUpdate(this.predict(randomVariable, string), string2);
    }

    public RandomVariable forward(RandomVariable randomVariable, String string) {
        return this.forward(randomVariable, "do_nothing", string);
    }

    public RandomVariable calculate_next_backward_message(RandomVariable randomVariable, RandomVariable randomVariable2, String string) {
        RandomVariable randomVariable3 = randomVariable2.duplicate();
        Matrix matrix = this.sensorModel.asMatrix(string);
        Matrix matrix2 = this.transitionModel.asMatrix();
        Matrix matrix3 = matrix2.times(matrix.times(randomVariable2.asMatrix()));
        Matrix matrix4 = matrix3.arrayTimes(randomVariable.asMatrix());
        randomVariable3.updateFrom(matrix4);
        randomVariable3.normalize();
        return randomVariable3;
    }

    public List<RandomVariable> forward_backward(List<String> list) {
        int n;
        RandomVariable[] randomVariableArray = new RandomVariable[list.size() + 1];
        RandomVariable randomVariable = this.priorDistribution.createUnitBelief();
        RandomVariable[] randomVariableArray2 = new RandomVariable[list.size() + 1];
        randomVariableArray[0] = this.priorDistribution;
        randomVariableArray2[0] = null;
        for (n = 0; n < list.size(); ++n) {
            randomVariableArray[n + 1] = this.forward(randomVariableArray[n], list.get(n));
        }
        for (n = list.size(); n > 0; --n) {
            RandomVariable randomVariable2 = this.priorDistribution.duplicate();
            randomVariable2.updateFrom(randomVariableArray[n].asMatrix().arrayTimes(randomVariable.asMatrix()));
            randomVariable2.normalize();
            randomVariableArray2[n] = randomVariable2;
            randomVariable = this.calculate_next_backward_message(randomVariableArray[n], randomVariable, list.get(n - 1));
        }
        return Arrays.asList(randomVariableArray2);
    }

    public SensorModel sensorModel() {
        return this.sensorModel;
    }

    public TransitionModel transitionModel() {
        return this.transitionModel;
    }
}

