/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.Randomizer;
import aima.probability.reasoning.HiddenMarkovModel;
import aima.probability.reasoning.Particle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ParticleSet {
    private List<Particle> particles = new ArrayList<Particle>();
    private HiddenMarkovModel hmm;

    public ParticleSet(HiddenMarkovModel hiddenMarkovModel) {
        this.hmm = hiddenMarkovModel;
    }

    public ParticleSet filter(String string, Randomizer randomizer) {
        return this.generateParticleSetForPredictedState(randomizer).perceptionUpdate(string, randomizer);
    }

    public ParticleSet filter(String string, String string2, Randomizer randomizer) {
        return this.generateParticleSetForPredictedState(string, randomizer).perceptionUpdate(string2, randomizer);
    }

    public int numberOfParticlesWithState(String string) {
        int n = 0;
        for (Particle particle : this.particles) {
            if (!particle.hasState(string)) continue;
            ++n;
        }
        return n;
    }

    public void add(Particle particle) {
        this.particles.add(particle);
    }

    public int size() {
        return this.particles.size();
    }

    public RandomVariable toRandomVariable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (Particle object : this.particles) {
            String string = object.getState();
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                hashtable.put(string, 0);
            }
            hashtable.put(string, (Integer)hashtable.get(string) + 1);
        }
        RandomVariable randomVariable = new RandomVariable(arrayList);
        for (String string : hashtable.keySet()) {
            randomVariable.setProbabilityOf(string, (double)((Integer)hashtable.get(string)).intValue() / (double)this.particles.size());
        }
        return randomVariable;
    }

    public ParticleSet generateParticleSetForPredictedState(Randomizer randomizer) {
        return this.generateParticleSetForPredictedState("do_nothing", randomizer);
    }

    public ParticleSet generateParticleSetForPredictedState(String string, Randomizer randomizer) {
        ParticleSet particleSet = new ParticleSet(this.hmm);
        for (Particle particle : this.particles) {
            String string2 = this.hmm.transitionModel().getStateForProbability(particle.getState(), string, randomizer.nextDouble());
            Particle particle2 = new Particle(string2);
            particleSet.add(particle2);
        }
        return particleSet;
    }

    public ParticleSet perceptionUpdate(String string, Randomizer randomizer) {
        for (Particle object : this.particles) {
            double d = this.hmm.sensorModel().get(object.getState(), string);
            object.setWeight(d);
        }
        ParticleSet particleSet = new ParticleSet(this.hmm);
        while (particleSet.size() != this.size()) {
            for (Particle particle : this.particles) {
                double d = randomizer.nextDouble();
                if (!(d <= particle.getWeight()) || particleSet.size() >= this.size()) continue;
                particleSet.add(new Particle(particle.getState(), particle.getWeight()));
            }
        }
        return particleSet;
    }

    public Particle getParticle(int n) {
        return this.particles.get(n);
    }
}

