/*
 * Decompiled with CFR 0.152.
 */
package aima.search.demos;

import aima.search.framework.GoalTest;
import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.SuccessorFunction;
import aima.search.framework.TreeSearch;
import aima.search.informed.HillClimbingSearch;
import aima.search.informed.SimulatedAnnealingSearch;
import aima.search.informed.ga.FitnessFunction;
import aima.search.informed.ga.GeneticAlgorithm;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensFitnessFunction;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.nqueens.QueensToBePlacedHeuristic;
import aima.search.uninformed.BreadthFirstSearch;
import aima.search.uninformed.DepthFirstSearch;
import aima.search.uninformed.DepthLimitedSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class NQueensDemo {
    public static void main(String[] stringArray) {
        NQueensDemo.newNQueensDemo();
    }

    private static void newNQueensDemo() {
        NQueensDemo.nQueensWithDepthFirstSearch();
        NQueensDemo.nQueensWithBreadthFirstSearch();
        NQueensDemo.nQueensWithRecursiveDLS();
        NQueensDemo.nQueensWithIterativeDeepeningSearch();
        NQueensDemo.nQueensSimulatedAnnealingSearch();
        NQueensDemo.nQueensHillClimbingSearch();
        NQueensDemo.nQueensGeneticAlgorithmSearch();
    }

    private static void nQueensWithRecursiveDLS() {
        System.out.println("\nNQueensDemo recursive DLS -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            DepthLimitedSearch depthLimitedSearch = new DepthLimitedSearch(8);
            SearchAgent searchAgent = new SearchAgent(problem, depthLimitedSearch);
            NQueensDemo.printActions(searchAgent.getActions());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nQueensWithBreadthFirstSearch() {
        try {
            System.out.println("\nNQueensDemo BFS -->");
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(new TreeSearch());
            SearchAgent searchAgent = new SearchAgent(problem, breadthFirstSearch);
            NQueensDemo.printActions(searchAgent.getActions());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nQueensWithDepthFirstSearch() {
        System.out.println("\nNQueensDemo DFS -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            DepthFirstSearch depthFirstSearch = new DepthFirstSearch(new GraphSearch());
            SearchAgent searchAgent = new SearchAgent(problem, depthFirstSearch);
            NQueensDemo.printActions(searchAgent.getActions());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nQueensWithIterativeDeepeningSearch() {
        System.out.println("\nNQueensDemo Iterative DS  -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            IterativeDeepeningSearch iterativeDeepeningSearch = new IterativeDeepeningSearch();
            SearchAgent searchAgent = new SearchAgent(problem, iterativeDeepeningSearch);
            System.out.println();
            NQueensDemo.printActions(searchAgent.getActions());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nQueensSimulatedAnnealingSearch() {
        System.out.println("\nNQueensDemo Simulated Annealing  -->");
        try {
            Problem problem = new Problem((Object)new NQueensBoard(8), (SuccessorFunction)new NQueensSuccessorFunction(), (GoalTest)new NQueensGoalTest(), new QueensToBePlacedHeuristic());
            SimulatedAnnealingSearch simulatedAnnealingSearch = new SimulatedAnnealingSearch();
            SearchAgent searchAgent = new SearchAgent(problem, simulatedAnnealingSearch);
            System.out.println();
            NQueensDemo.printActions(searchAgent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)simulatedAnnealingSearch.getOutcome()));
            System.out.println("Final State=\n" + simulatedAnnealingSearch.getLastSearchState());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nQueensHillClimbingSearch() {
        System.out.println("\nNQueensDemo HillClimbing  -->");
        try {
            Problem problem = new Problem((Object)new NQueensBoard(8), (SuccessorFunction)new NQueensSuccessorFunction(), (GoalTest)new NQueensGoalTest(), new QueensToBePlacedHeuristic());
            HillClimbingSearch hillClimbingSearch = new HillClimbingSearch();
            SearchAgent searchAgent = new SearchAgent(problem, hillClimbingSearch);
            System.out.println();
            NQueensDemo.printActions(searchAgent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)hillClimbingSearch.getOutcome()));
            System.out.println("Final State=\n" + hillClimbingSearch.getLastSearchState());
            NQueensDemo.printInstrumentation(searchAgent.getInstrumentation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void nQueensGeneticAlgorithmSearch() {
        System.out.println("\nNQueensDemo GeneticAlgorithm  -->");
        try {
            int n = 8;
            NQueensFitnessFunction nQueensFitnessFunction = new NQueensFitnessFunction();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                hashSet.add(nQueensFitnessFunction.generateRandomIndividual(n));
            }
            GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm(n, nQueensFitnessFunction.getFiniteAlphabetForBoardOfSize(n), 0.15);
            String string = geneticAlgorithm.geneticAlgorithm(hashSet, (FitnessFunction)nQueensFitnessFunction, 100);
            System.out.println("Iterations Best Individual=\n" + nQueensFitnessFunction.getBoardForIndividual(string));
            System.out.println("Fitness=" + nQueensFitnessFunction.getValue(string));
            System.out.println("Is Goal=" + nQueensFitnessFunction.isGoalState(string));
            System.out.println("Itertions=" + geneticAlgorithm.getIterations());
            string = geneticAlgorithm.geneticAlgorithm(hashSet, (FitnessFunction)nQueensFitnessFunction, nQueensFitnessFunction);
            System.out.println("Goal Test Best Individual=\n" + nQueensFitnessFunction.getBoardForIndividual(string));
            System.out.println("Fitness=" + nQueensFitnessFunction.getValue(string));
            System.out.println("Is Goal=" + nQueensFitnessFunction.isGoalState(string));
            System.out.println("Itertions=" + geneticAlgorithm.getIterations());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printInstrumentation(Properties properties) {
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            System.out.println(string + " : " + string2);
        }
    }

    private static void printActions(List list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            System.out.println(string);
        }
    }
}

