/*
 * Decompiled with CFR 0.152.
 */
package aima.search.eightpuzzle;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class EightPuzzleBoard {
    public static String LEFT = "Left";
    public static String RIGHT = "Right";
    public static String UP = "Up";
    public static String DOWN = "Down";
    int[] board;

    public int[] getBoard() {
        return this.board;
    }

    public EightPuzzleBoard() {
        this.board = new int[]{5, 4, 0, 6, 1, 8, 7, 3, 2};
    }

    public EightPuzzleBoard(int[] nArray) {
        this.board = nArray;
    }

    private int[] xycoordinatesFromAbsoluteCoordinate(int n) {
        int[] nArray = null;
        switch (n) {
            case 0: {
                nArray = new int[]{0, 0};
                break;
            }
            case 1: {
                nArray = new int[]{0, 1};
                break;
            }
            case 2: {
                nArray = new int[]{0, 2};
                break;
            }
            case 3: {
                nArray = new int[]{1, 0};
                break;
            }
            case 4: {
                nArray = new int[]{1, 1};
                break;
            }
            case 5: {
                nArray = new int[]{1, 2};
                break;
            }
            case 6: {
                nArray = new int[]{2, 0};
                break;
            }
            case 7: {
                nArray = new int[]{2, 1};
                break;
            }
            case 8: {
                nArray = new int[]{2, 2};
            }
        }
        return nArray;
    }

    private int absoluteCoordinatesFromXYCoordinates(int n, int n2) {
        return n * 3 + n2;
    }

    private int getValueAt(int n, int n2) {
        return this.board[this.absoluteCoordinatesFromXYCoordinates(n, n2)];
    }

    private int getGapPosition() {
        return this.getPositionOf(0);
    }

    private int getPositionOf(int n) {
        int n2 = -1;
        for (int i = 0; i < 9; ++i) {
            if (this.board[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    public XYLocation getLocationOf(int n) {
        int n2 = this.getPositionOf(n);
        int n3 = this.xycoordinatesFromAbsoluteCoordinate(n2)[0];
        int n4 = this.xycoordinatesFromAbsoluteCoordinate(n2)[1];
        return new XYLocation(n3, n4);
    }

    private void setValue(int n, int n2, int n3) {
        int n4 = this.absoluteCoordinatesFromXYCoordinates(n, n2);
        this.board[n4] = n3;
    }

    public int getValueAt(XYLocation xYLocation) {
        return this.getValueAt(xYLocation.getXCoOrdinate(), xYLocation.getYCoOrdinate());
    }

    public void moveGapRight() {
        int n = this.getGapPosition();
        int n2 = this.xycoordinatesFromAbsoluteCoordinate(n)[0];
        int n3 = this.xycoordinatesFromAbsoluteCoordinate(n)[1];
        if (n3 != 2) {
            int n4 = this.getValueAt(n2, n3 + 1);
            this.setValue(n2, n3, n4);
            this.setValue(n2, n3 + 1, 0);
        }
    }

    public void moveGapLeft() {
        int n = this.getGapPosition();
        int n2 = this.xycoordinatesFromAbsoluteCoordinate(n)[0];
        int n3 = this.xycoordinatesFromAbsoluteCoordinate(this.getGapPosition())[1];
        if (n3 != 0) {
            int n4 = this.getValueAt(n2, n3 - 1);
            this.setValue(n2, n3, n4);
            this.setValue(n2, n3 - 1, 0);
        }
    }

    public void moveGapDown() {
        int n = this.getGapPosition();
        int n2 = this.xycoordinatesFromAbsoluteCoordinate(n)[0];
        int n3 = this.xycoordinatesFromAbsoluteCoordinate(n)[1];
        if (n2 != 2) {
            int n4 = this.getValueAt(n2 + 1, n3);
            this.setValue(n2, n3, n4);
            this.setValue(n2 + 1, n3, 0);
        }
    }

    public void moveGapUp() {
        int n = this.getGapPosition();
        int n2 = this.xycoordinatesFromAbsoluteCoordinate(n)[0];
        int n3 = this.xycoordinatesFromAbsoluteCoordinate(n)[1];
        if (n2 != 0) {
            int n4 = this.getValueAt(n2 - 1, n3);
            this.setValue(n2, n3, n4);
            this.setValue(n2 - 1, n3, 0);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EightPuzzleBoard eightPuzzleBoard = (EightPuzzleBoard)object;
        for (int i = 0; i < 8; ++i) {
            if (this.getPositionOf(i) == eightPuzzleBoard.getPositionOf(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < 8; ++i) {
            int n2 = this.getPositionOf(i);
            n = 37 * n + n2;
        }
        return n;
    }

    public List<XYLocation> getPositions() {
        ArrayList<XYLocation> arrayList = new ArrayList<XYLocation>();
        for (int i = 0; i < 9; ++i) {
            int[] nArray = this.xycoordinatesFromAbsoluteCoordinate(this.getPositionOf(i));
            XYLocation xYLocation = new XYLocation(nArray[0], nArray[1]);
            arrayList.add(xYLocation);
        }
        return arrayList;
    }

    public void setBoard(List<XYLocation> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            XYLocation xYLocation = list.get(i);
            this.setValue(xYLocation.getXCoOrdinate(), xYLocation.getYCoOrdinate(), n);
            ++n;
        }
    }

    public boolean canMoveGap(String string) {
        boolean bl = true;
        int n = this.getPositionOf(0);
        if (string.equals(LEFT) && (n == 0 || n == 3 || n == 6)) {
            bl = false;
        }
        if (string.equals(RIGHT) && (n == 2 || n == 5 || n == 8)) {
            bl = false;
        }
        if (string.equals(UP) && (n == 0 || n == 1 || n == 2)) {
            bl = false;
        }
        if (string.equals(DOWN) && (n == 6 || n == 7 || n == 8)) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        String string = this.board[0] + " " + this.board[1] + " " + this.board[2] + "\n" + this.board[3] + " " + this.board[4] + " " + this.board[5] + " " + "\n" + this.board[6] + " " + this.board[7] + " " + this.board[8];
        return string;
    }
}

