/*
 * Decompiled with CFR 0.152.
 */
package aima.search.eightpuzzle;

import aima.basic.XYLocation;
import aima.search.eightpuzzle.EightPuzzleBoard;
import aima.search.framework.HeuristicFunction;

public class ManhattanHeuristicFunction
implements HeuristicFunction {
    @Override
    public double getHeuristicValue(Object object) {
        EightPuzzleBoard eightPuzzleBoard = (EightPuzzleBoard)object;
        int n = 0;
        for (int i = 1; i < 9; ++i) {
            XYLocation xYLocation = eightPuzzleBoard.getLocationOf(i);
            n += this.evaluateManhattanDistanceOf(i, xYLocation);
        }
        return n;
    }

    public int evaluateManhattanDistanceOf(int n, XYLocation xYLocation) {
        int n2 = -1;
        int n3 = xYLocation.getXCoOrdinate();
        int n4 = xYLocation.getYCoOrdinate();
        switch (n) {
            case 1: {
                n2 = Math.abs(n3 - 0) + Math.abs(n4 - 1);
                break;
            }
            case 2: {
                n2 = Math.abs(n3 - 0) + Math.abs(n4 - 2);
                break;
            }
            case 3: {
                n2 = Math.abs(n3 - 1) + Math.abs(n4 - 0);
                break;
            }
            case 4: {
                n2 = Math.abs(n3 - 1) + Math.abs(n4 - 1);
                break;
            }
            case 5: {
                n2 = Math.abs(n3 - 1) + Math.abs(n4 - 2);
                break;
            }
            case 6: {
                n2 = Math.abs(n3 - 2) + Math.abs(n4 - 0);
                break;
            }
            case 7: {
                n2 = Math.abs(n3 - 2) + Math.abs(n4 - 1);
                break;
            }
            case 8: {
                n2 = Math.abs(n3 - 2) + Math.abs(n4 - 2);
            }
        }
        return n2;
    }
}

