/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.NodeStore;
import aima.search.framework.Problem;
import aima.search.framework.SearchUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class QueueSearch
extends NodeExpander {
    private static String QUEUE_SIZE = "queueSize";
    private static String MAX_QUEUE_SIZE = "maxQueueSize";
    private static String PATH_COST = "pathCost";

    public List<String> search(Problem problem, NodeStore nodeStore) {
        this.clearInstrumentation();
        nodeStore.add(new Node(problem.getInitialState()));
        this.setQueueSize(nodeStore.size());
        while (!nodeStore.isEmpty()) {
            Node node = nodeStore.remove();
            this.setQueueSize(nodeStore.size());
            if (problem.isGoalState(node.getState())) {
                this.setPathCost(node.getPathCost());
                return SearchUtils.actionsFromNodes(node.getPathFromRoot());
            }
            this.addExpandedNodesToFringe(nodeStore, node, problem);
            this.setQueueSize(nodeStore.size());
        }
        return new ArrayList<String>();
    }

    @Override
    public void clearInstrumentation() {
        super.clearInstrumentation();
        this.metrics.set(QUEUE_SIZE, 0);
        this.metrics.set(MAX_QUEUE_SIZE, 0);
        this.metrics.set(PATH_COST, 0);
    }

    public int getQueueSize() {
        return this.metrics.getInt("queueSize");
    }

    public void setQueueSize(int n) {
        this.metrics.set(QUEUE_SIZE, n);
        int n2 = this.metrics.getInt(MAX_QUEUE_SIZE);
        if (n > n2) {
            this.metrics.set(MAX_QUEUE_SIZE, n);
        }
    }

    public int getMaxQueueSize() {
        return this.metrics.getInt(MAX_QUEUE_SIZE);
    }

    public double getPathCost() {
        return this.metrics.getDouble(PATH_COST);
    }

    public void setPathCost(Double d) {
        this.metrics.set(PATH_COST, d);
    }

    public abstract void addExpandedNodesToFringe(NodeStore var1, Node var2, Problem var3);
}

