/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.GraphSearch;
import aima.search.framework.QueueSearch;
import aima.search.framework.Search;
import aima.search.framework.TreeSearch;
import aima.search.informed.AStarEvaluationFunction;
import aima.search.informed.AStarSearch;
import aima.search.informed.GreedyBestFirstSearch;
import aima.search.informed.HillClimbingSearch;
import aima.search.informed.RecursiveBestFirstSearch;
import aima.search.uninformed.BreadthFirstSearch;
import aima.search.uninformed.DepthFirstSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import aima.search.uninformed.UniformCostSearch;

public class SearchFactory {
    public static final int DF_SEARCH = 0;
    public static final int BF_SEARCH = 1;
    public static final int ID_SEARCH = 2;
    public static final int UC_SEARCH = 3;
    public static final int GBF_SEARCH = 4;
    public static final int ASTAR_SEARCH = 5;
    public static final int RBF_SEARCH = 6;
    public static final int HILL_SEARCH = 7;
    public static final int TREE_SEARCH = 0;
    public static final int GRAPH_SEARCH = 1;
    private static SearchFactory instance;

    private SearchFactory() {
    }

    public static SearchFactory getInstance() {
        if (instance == null) {
            instance = new SearchFactory();
        }
        return instance;
    }

    public String[] getSearchStrategyNames() {
        return new String[]{"Depth First", "Breadth First", "Iterative Deepening", "Uniform Cost", "Greedy Best First", "A*", "Recursive Best First", "Hill Climbing"};
    }

    public String[] getSearchModeNames() {
        return new String[]{"Tree Search", "Graph Search"};
    }

    public Search createSearch(int n, int n2) {
        QueueSearch queueSearch = null;
        Search search = null;
        switch (n2) {
            case 0: {
                queueSearch = new TreeSearch();
                break;
            }
            case 1: {
                queueSearch = new GraphSearch();
            }
        }
        switch (n) {
            case 0: {
                search = new DepthFirstSearch(queueSearch);
                break;
            }
            case 1: {
                search = new BreadthFirstSearch(queueSearch);
                break;
            }
            case 2: {
                search = new IterativeDeepeningSearch();
                break;
            }
            case 3: {
                search = new UniformCostSearch(queueSearch);
                break;
            }
            case 4: {
                search = new GreedyBestFirstSearch(queueSearch);
                break;
            }
            case 5: {
                search = new AStarSearch(queueSearch);
                break;
            }
            case 6: {
                search = new RecursiveBestFirstSearch(new AStarEvaluationFunction());
                break;
            }
            case 7: {
                search = new HillClimbingSearch();
            }
        }
        return search;
    }
}

